@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.AdmChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint ADM (Amazon Device Messaging) Channel resource.
 * > **Note:** All arguments including the Client ID and Client Secret will be stored in the raw state as plain-text.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const app = new aws.pinpoint.App("app", {});
 * const channel = new aws.pinpoint.AdmChannel("channel", {
 *     applicationId: app.applicationId,
 *     clientId: "",
 *     clientSecret: "",
 *     enabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * app = aws.pinpoint.App("app")
 * channel = aws.pinpoint.AdmChannel("channel",
 *     application_id=app.application_id,
 *     client_id="",
 *     client_secret="",
 *     enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new Aws.Pinpoint.App("app");
 *     var channel = new Aws.Pinpoint.AdmChannel("channel", new()
 *     {
 *         ApplicationId = app.ApplicationId,
 *         ClientId = "",
 *         ClientSecret = "",
 *         Enabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/pinpoint"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		app, err := pinpoint.NewApp(ctx, "app", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pinpoint.NewAdmChannel(ctx, "channel", &pinpoint.AdmChannelArgs{
 * 			ApplicationId: app.ApplicationId,
 * 			ClientId:      pulumi.String(""),
 * 			ClientSecret:  pulumi.String(""),
 * 			Enabled:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AdmChannel;
 * import com.pulumi.aws.pinpoint.AdmChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var channel = new AdmChannel("channel", AdmChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .clientId("")
 *             .clientSecret("")
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   app:
 *     type: aws:pinpoint:App
 *   channel:
 *     type: aws:pinpoint:AdmChannel
 *     properties:
 *       applicationId: ${app.applicationId}
 *       clientId:
 *       clientSecret:
 *       enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Pinpoint ADM Channel using the `application-id`. For example:
 * ```sh
 * $ pulumi import aws:pinpoint/admChannel:AdmChannel channel application-id
 * ```
 * @property applicationId The application ID.
 * @property clientId Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
 * @property clientSecret Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
 * @property enabled Specifies whether to enable the channel. Defaults to `true`.
 */
public data class AdmChannelArgs(
    public val applicationId: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.AdmChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.AdmChannelArgs =
        com.pulumi.aws.pinpoint.AdmChannelArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdmChannelArgs].
 */
@PulumiTagMarker
public class AdmChannelArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The application ID.
     */
    @JvmName("obyxohksfjskqibq")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("psiwpavbsybhrbqd")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("vqywgtvvbxutldgh")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("hfkysfrtrwydkbia")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("budlhwsvwwsrlngt")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("wnlidgphiihqpwgv")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
     */
    @JvmName("lpqbgykqhuixwmqs")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("skeccypthsdjpsuj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): AdmChannelArgs = AdmChannelArgs(
        applicationId = applicationId,
        clientId = clientId,
        clientSecret = clientSecret,
        enabled = enabled,
    )
}
