@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApnsChannel].
 */
@PulumiTagMarker
public class ApnsChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApnsChannelArgs = ApnsChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApnsChannelArgsBuilder.() -> Unit) {
        val builder = ApnsChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApnsChannel {
        val builtJavaResource = com.pulumi.aws.pinpoint.ApnsChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApnsChannel(builtJavaResource)
    }
}

/**
 * Provides a Pinpoint APNs Channel resource.
 * > **Note:** All arguments, including certificates and tokens, will be stored in the raw state as plain-text.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const app = new aws.pinpoint.App("app", {});
 * const apns = new aws.pinpoint.ApnsChannel("apns", {
 *     applicationId: app.applicationId,
 *     certificate: std.file({
 *         input: "./certificate.pem",
 *     }).then(invoke => invoke.result),
 *     privateKey: std.file({
 *         input: "./private_key.key",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * app = aws.pinpoint.App("app")
 * apns = aws.pinpoint.ApnsChannel("apns",
 *     application_id=app.application_id,
 *     certificate=std.file(input="./certificate.pem").result,
 *     private_key=std.file(input="./private_key.key").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new Aws.Pinpoint.App("app");
 *     var apns = new Aws.Pinpoint.ApnsChannel("apns", new()
 *     {
 *         ApplicationId = app.ApplicationId,
 *         Certificate = Std.File.Invoke(new()
 *         {
 *             Input = "./certificate.pem",
 *         }).Apply(invoke => invoke.Result),
 *         PrivateKey = Std.File.Invoke(new()
 *         {
 *             Input = "./private_key.key",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/pinpoint"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		app, err := pinpoint.NewApp(ctx, "app", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./certificate.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile1, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./private_key.key",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pinpoint.NewApnsChannel(ctx, "apns", &pinpoint.ApnsChannelArgs{
 * 			ApplicationId: app.ApplicationId,
 * 			Certificate:   pulumi.String(invokeFile.Result),
 * 			PrivateKey:    pulumi.String(invokeFile1.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.ApnsChannel;
 * import com.pulumi.aws.pinpoint.ApnsChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var apns = new ApnsChannel("apns", ApnsChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .certificate(StdFunctions.file(FileArgs.builder()
 *                 .input("./certificate.pem")
 *                 .build()).result())
 *             .privateKey(StdFunctions.file(FileArgs.builder()
 *                 .input("./private_key.key")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   apns:
 *     type: aws:pinpoint:ApnsChannel
 *     properties:
 *       applicationId: ${app.applicationId}
 *       certificate:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: ./certificate.pem
 *           Return: result
 *       privateKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: ./private_key.key
 *           Return: result
 *   app:
 *     type: aws:pinpoint:App
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Pinpoint APNs Channel using the `application-id`. For example:
 * ```sh
 * $ pulumi import aws:pinpoint/apnsChannel:ApnsChannel apns application-id
 * ```
 */
public class ApnsChannel internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.ApnsChannel,
) : KotlinCustomResource(javaResource, ApnsChannelMapper) {
    /**
     * The application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * The ID assigned to your iOS app. To find this value, choose Certificates, IDs & Profiles, choose App IDs in the Identifiers section, and choose your app.
     */
    public val bundleId: Output<String>?
        get() = javaResource.bundleId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The pem encoded TLS Certificate from Apple.
     */
    public val certificate: Output<String>?
        get() = javaResource.certificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default authentication method used for APNs.
     * __NOTE__: Amazon Pinpoint uses this default for every APNs push notification that you send using the console.
     * You can override the default when you send a message programmatically using the Amazon Pinpoint API, the AWS CLI, or an AWS SDK.
     * If your default authentication type fails, Amazon Pinpoint doesn't attempt to use the other authentication type.
     * One of the following sets of credentials is also required.
     * If you choose to use __Certificate credentials__ you will have to provide:
     */
    public val defaultAuthenticationMethod: Output<String>?
        get() = javaResource.defaultAuthenticationMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the channel is enabled or disabled. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Certificate Private Key file (ie. `.key` file).
     * If you choose to use __Key credentials__ you will have to provide:
     */
    public val privateKey: Output<String>?
        get() = javaResource.privateKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID assigned to your Apple developer account team. This value is provided on the Membership page.
     */
    public val teamId: Output<String>?
        get() = javaResource.teamId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The `.p8` file that you download from your Apple developer account when you create an authentication key.
     */
    public val tokenKey: Output<String>?
        get() = javaResource.tokenKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID assigned to your signing key. To find this value, choose Certificates, IDs & Profiles, and choose your key in the Keys section.
     */
    public val tokenKeyId: Output<String>?
        get() = javaResource.tokenKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ApnsChannelMapper : ResourceMapper<ApnsChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.ApnsChannel::class == javaResource::class

    override fun map(javaResource: Resource): ApnsChannel = ApnsChannel(
        javaResource as
            com.pulumi.aws.pinpoint.ApnsChannel,
    )
}

/**
 * @see [ApnsChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApnsChannel].
 */
public suspend fun apnsChannel(name: String, block: suspend ApnsChannelResourceBuilder.() -> Unit): ApnsChannel {
    val builder = ApnsChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApnsChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apnsChannel(name: String): ApnsChannel {
    val builder = ApnsChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
