@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.ApnsChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint APNs Channel resource.
 * > **Note:** All arguments, including certificates and tokens, will be stored in the raw state as plain-text.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const app = new aws.pinpoint.App("app", {});
 * const apns = new aws.pinpoint.ApnsChannel("apns", {
 *     applicationId: app.applicationId,
 *     certificate: std.file({
 *         input: "./certificate.pem",
 *     }).then(invoke => invoke.result),
 *     privateKey: std.file({
 *         input: "./private_key.key",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * app = aws.pinpoint.App("app")
 * apns = aws.pinpoint.ApnsChannel("apns",
 *     application_id=app.application_id,
 *     certificate=std.file(input="./certificate.pem").result,
 *     private_key=std.file(input="./private_key.key").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new Aws.Pinpoint.App("app");
 *     var apns = new Aws.Pinpoint.ApnsChannel("apns", new()
 *     {
 *         ApplicationId = app.ApplicationId,
 *         Certificate = Std.File.Invoke(new()
 *         {
 *             Input = "./certificate.pem",
 *         }).Apply(invoke => invoke.Result),
 *         PrivateKey = Std.File.Invoke(new()
 *         {
 *             Input = "./private_key.key",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/pinpoint"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		app, err := pinpoint.NewApp(ctx, "app", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./certificate.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile1, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./private_key.key",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pinpoint.NewApnsChannel(ctx, "apns", &pinpoint.ApnsChannelArgs{
 * 			ApplicationId: app.ApplicationId,
 * 			Certificate:   pulumi.String(invokeFile.Result),
 * 			PrivateKey:    pulumi.String(invokeFile1.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.ApnsChannel;
 * import com.pulumi.aws.pinpoint.ApnsChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var apns = new ApnsChannel("apns", ApnsChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .certificate(StdFunctions.file(FileArgs.builder()
 *                 .input("./certificate.pem")
 *                 .build()).result())
 *             .privateKey(StdFunctions.file(FileArgs.builder()
 *                 .input("./private_key.key")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   apns:
 *     type: aws:pinpoint:ApnsChannel
 *     properties:
 *       applicationId: ${app.applicationId}
 *       certificate:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: ./certificate.pem
 *           Return: result
 *       privateKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: ./private_key.key
 *           Return: result
 *   app:
 *     type: aws:pinpoint:App
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Pinpoint APNs Channel using the `application-id`. For example:
 * ```sh
 * $ pulumi import aws:pinpoint/apnsChannel:ApnsChannel apns application-id
 * ```
 * @property applicationId The application ID.
 * @property bundleId The ID assigned to your iOS app. To find this value, choose Certificates, IDs & Profiles, choose App IDs in the Identifiers section, and choose your app.
 * @property certificate The pem encoded TLS Certificate from Apple.
 * @property defaultAuthenticationMethod The default authentication method used for APNs.
 * __NOTE__: Amazon Pinpoint uses this default for every APNs push notification that you send using the console.
 * You can override the default when you send a message programmatically using the Amazon Pinpoint API, the AWS CLI, or an AWS SDK.
 * If your default authentication type fails, Amazon Pinpoint doesn't attempt to use the other authentication type.
 * One of the following sets of credentials is also required.
 * If you choose to use __Certificate credentials__ you will have to provide:
 * @property enabled Whether the channel is enabled or disabled. Defaults to `true`.
 * @property privateKey The Certificate Private Key file (ie. `.key` file).
 * If you choose to use __Key credentials__ you will have to provide:
 * @property teamId The ID assigned to your Apple developer account team. This value is provided on the Membership page.
 * @property tokenKey The `.p8` file that you download from your Apple developer account when you create an authentication key.
 * @property tokenKeyId The ID assigned to your signing key. To find this value, choose Certificates, IDs & Profiles, and choose your key in the Keys section.
 */
public data class ApnsChannelArgs(
    public val applicationId: Output<String>? = null,
    public val bundleId: Output<String>? = null,
    public val certificate: Output<String>? = null,
    public val defaultAuthenticationMethod: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val privateKey: Output<String>? = null,
    public val teamId: Output<String>? = null,
    public val tokenKey: Output<String>? = null,
    public val tokenKeyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.ApnsChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.ApnsChannelArgs =
        com.pulumi.aws.pinpoint.ApnsChannelArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .defaultAuthenticationMethod(defaultAuthenticationMethod?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .teamId(teamId?.applyValue({ args0 -> args0 }))
            .tokenKey(tokenKey?.applyValue({ args0 -> args0 }))
            .tokenKeyId(tokenKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApnsChannelArgs].
 */
@PulumiTagMarker
public class ApnsChannelArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var bundleId: Output<String>? = null

    private var certificate: Output<String>? = null

    private var defaultAuthenticationMethod: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var privateKey: Output<String>? = null

    private var teamId: Output<String>? = null

    private var tokenKey: Output<String>? = null

    private var tokenKeyId: Output<String>? = null

    /**
     * @param value The application ID.
     */
    @JvmName("ngfmiafjqejhlfrv")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The ID assigned to your iOS app. To find this value, choose Certificates, IDs & Profiles, choose App IDs in the Identifiers section, and choose your app.
     */
    @JvmName("ebyetyguqfvrmkwk")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The pem encoded TLS Certificate from Apple.
     */
    @JvmName("agvoggsnguvtqeyd")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The default authentication method used for APNs.
     * __NOTE__: Amazon Pinpoint uses this default for every APNs push notification that you send using the console.
     * You can override the default when you send a message programmatically using the Amazon Pinpoint API, the AWS CLI, or an AWS SDK.
     * If your default authentication type fails, Amazon Pinpoint doesn't attempt to use the other authentication type.
     * One of the following sets of credentials is also required.
     * If you choose to use __Certificate credentials__ you will have to provide:
     */
    @JvmName("wgrvykcyxalavirp")
    public suspend fun defaultAuthenticationMethod(`value`: Output<String>) {
        this.defaultAuthenticationMethod = value
    }

    /**
     * @param value Whether the channel is enabled or disabled. Defaults to `true`.
     */
    @JvmName("scpcvtutekppkubv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The Certificate Private Key file (ie. `.key` file).
     * If you choose to use __Key credentials__ you will have to provide:
     */
    @JvmName("lrxeicfnnoujtqns")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value The ID assigned to your Apple developer account team. This value is provided on the Membership page.
     */
    @JvmName("gbsheyrxyoocxsiq")
    public suspend fun teamId(`value`: Output<String>) {
        this.teamId = value
    }

    /**
     * @param value The `.p8` file that you download from your Apple developer account when you create an authentication key.
     */
    @JvmName("vqusavgdtbvjqxic")
    public suspend fun tokenKey(`value`: Output<String>) {
        this.tokenKey = value
    }

    /**
     * @param value The ID assigned to your signing key. To find this value, choose Certificates, IDs & Profiles, and choose your key in the Keys section.
     */
    @JvmName("uenplladdxafvtut")
    public suspend fun tokenKeyId(`value`: Output<String>) {
        this.tokenKeyId = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("rvavyumvauuxarbi")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value The ID assigned to your iOS app. To find this value, choose Certificates, IDs & Profiles, choose App IDs in the Identifiers section, and choose your app.
     */
    @JvmName("vmstosrmordmjold")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The pem encoded TLS Certificate from Apple.
     */
    @JvmName("xmfcshxuohrmlugy")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The default authentication method used for APNs.
     * __NOTE__: Amazon Pinpoint uses this default for every APNs push notification that you send using the console.
     * You can override the default when you send a message programmatically using the Amazon Pinpoint API, the AWS CLI, or an AWS SDK.
     * If your default authentication type fails, Amazon Pinpoint doesn't attempt to use the other authentication type.
     * One of the following sets of credentials is also required.
     * If you choose to use __Certificate credentials__ you will have to provide:
     */
    @JvmName("qoubxjveoksekogi")
    public suspend fun defaultAuthenticationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAuthenticationMethod = mapped
    }

    /**
     * @param value Whether the channel is enabled or disabled. Defaults to `true`.
     */
    @JvmName("mudprahbyuulpjwl")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The Certificate Private Key file (ie. `.key` file).
     * If you choose to use __Key credentials__ you will have to provide:
     */
    @JvmName("vpbetqkmmftfxrfj")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The ID assigned to your Apple developer account team. This value is provided on the Membership page.
     */
    @JvmName("tehftyqkcjduuydp")
    public suspend fun teamId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teamId = mapped
    }

    /**
     * @param value The `.p8` file that you download from your Apple developer account when you create an authentication key.
     */
    @JvmName("tnpqsiifippkamay")
    public suspend fun tokenKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenKey = mapped
    }

    /**
     * @param value The ID assigned to your signing key. To find this value, choose Certificates, IDs & Profiles, and choose your key in the Keys section.
     */
    @JvmName("vsrwiofwnfvqkfjg")
    public suspend fun tokenKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenKeyId = mapped
    }

    internal fun build(): ApnsChannelArgs = ApnsChannelArgs(
        applicationId = applicationId,
        bundleId = bundleId,
        certificate = certificate,
        defaultAuthenticationMethod = defaultAuthenticationMethod,
        enabled = enabled,
        privateKey = privateKey,
        teamId = teamId,
        tokenKey = tokenKey,
        tokenKeyId = tokenKeyId,
    )
}
