@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BaiduChannel].
 */
@PulumiTagMarker
public class BaiduChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BaiduChannelArgs = BaiduChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BaiduChannelArgsBuilder.() -> Unit) {
        val builder = BaiduChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BaiduChannel {
        val builtJavaResource = com.pulumi.aws.pinpoint.BaiduChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BaiduChannel(builtJavaResource)
    }
}

/**
 * Provides a Pinpoint Baidu Channel resource.
 * > **Note:** All arguments including the Api Key and Secret Key will be stored in the raw state as plain-text.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const app = new aws.pinpoint.App("app", {});
 * const channel = new aws.pinpoint.BaiduChannel("channel", {
 *     applicationId: app.applicationId,
 *     apiKey: "",
 *     secretKey: "",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * app = aws.pinpoint.App("app")
 * channel = aws.pinpoint.BaiduChannel("channel",
 *     application_id=app.application_id,
 *     api_key="",
 *     secret_key="")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new Aws.Pinpoint.App("app");
 *     var channel = new Aws.Pinpoint.BaiduChannel("channel", new()
 *     {
 *         ApplicationId = app.ApplicationId,
 *         ApiKey = "",
 *         SecretKey = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/pinpoint"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		app, err := pinpoint.NewApp(ctx, "app", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pinpoint.NewBaiduChannel(ctx, "channel", &pinpoint.BaiduChannelArgs{
 * 			ApplicationId: app.ApplicationId,
 * 			ApiKey:        pulumi.String(""),
 * 			SecretKey:     pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.BaiduChannel;
 * import com.pulumi.aws.pinpoint.BaiduChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var channel = new BaiduChannel("channel", BaiduChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .apiKey("")
 *             .secretKey("")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   app:
 *     type: aws:pinpoint:App
 *   channel:
 *     type: aws:pinpoint:BaiduChannel
 *     properties:
 *       applicationId: ${app.applicationId}
 *       apiKey:
 *       secretKey:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Pinpoint Baidu Channel using the `application-id`. For example:
 * ```sh
 * $ pulumi import aws:pinpoint/baiduChannel:BaiduChannel channel application-id
 * ```
 */
public class BaiduChannel internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.BaiduChannel,
) : KotlinCustomResource(javaResource, BaiduChannelMapper) {
    /**
     * Platform credential API key from Baidu.
     */
    public val apiKey: Output<String>
        get() = javaResource.apiKey().applyValue({ args0 -> args0 })

    /**
     * The application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the channel. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Platform credential Secret key from Baidu.
     */
    public val secretKey: Output<String>
        get() = javaResource.secretKey().applyValue({ args0 -> args0 })
}

public object BaiduChannelMapper : ResourceMapper<BaiduChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.BaiduChannel::class == javaResource::class

    override fun map(javaResource: Resource): BaiduChannel = BaiduChannel(
        javaResource as
            com.pulumi.aws.pinpoint.BaiduChannel,
    )
}

/**
 * @see [BaiduChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BaiduChannel].
 */
public suspend fun baiduChannel(
    name: String,
    block: suspend BaiduChannelResourceBuilder.() -> Unit,
): BaiduChannel {
    val builder = BaiduChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BaiduChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun baiduChannel(name: String): BaiduChannel {
    val builder = BaiduChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
