@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.aws.pinpoint.BaiduChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Pinpoint Baidu Channel resource.
 * > **Note:** All arguments including the Api Key and Secret Key will be stored in the raw state as plain-text.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const app = new aws.pinpoint.App("app", {});
 * const channel = new aws.pinpoint.BaiduChannel("channel", {
 *     applicationId: app.applicationId,
 *     apiKey: "",
 *     secretKey: "",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * app = aws.pinpoint.App("app")
 * channel = aws.pinpoint.BaiduChannel("channel",
 *     application_id=app.application_id,
 *     api_key="",
 *     secret_key="")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new Aws.Pinpoint.App("app");
 *     var channel = new Aws.Pinpoint.BaiduChannel("channel", new()
 *     {
 *         ApplicationId = app.ApplicationId,
 *         ApiKey = "",
 *         SecretKey = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/pinpoint"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		app, err := pinpoint.NewApp(ctx, "app", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pinpoint.NewBaiduChannel(ctx, "channel", &pinpoint.BaiduChannelArgs{
 * 			ApplicationId: app.ApplicationId,
 * 			ApiKey:        pulumi.String(""),
 * 			SecretKey:     pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.BaiduChannel;
 * import com.pulumi.aws.pinpoint.BaiduChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         var channel = new BaiduChannel("channel", BaiduChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .apiKey("")
 *             .secretKey("")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   app:
 *     type: aws:pinpoint:App
 *   channel:
 *     type: aws:pinpoint:BaiduChannel
 *     properties:
 *       applicationId: ${app.applicationId}
 *       apiKey:
 *       secretKey:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Pinpoint Baidu Channel using the `application-id`. For example:
 * ```sh
 * $ pulumi import aws:pinpoint/baiduChannel:BaiduChannel channel application-id
 * ```
 * @property apiKey Platform credential API key from Baidu.
 * @property applicationId The application ID.
 * @property enabled Specifies whether to enable the channel. Defaults to `true`.
 * @property secretKey Platform credential Secret key from Baidu.
 */
public data class BaiduChannelArgs(
    public val apiKey: Output<String>? = null,
    public val applicationId: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val secretKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pinpoint.BaiduChannelArgs> {
    override fun toJava(): com.pulumi.aws.pinpoint.BaiduChannelArgs =
        com.pulumi.aws.pinpoint.BaiduChannelArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0 }))
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .secretKey(secretKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BaiduChannelArgs].
 */
@PulumiTagMarker
public class BaiduChannelArgsBuilder internal constructor() {
    private var apiKey: Output<String>? = null

    private var applicationId: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var secretKey: Output<String>? = null

    /**
     * @param value Platform credential API key from Baidu.
     */
    @JvmName("qyesbjavkqhyqvcg")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value The application ID.
     */
    @JvmName("tvipniybnccogjvo")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("qefjsqpcelhtqjrr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Platform credential Secret key from Baidu.
     */
    @JvmName("cxixrwphtwpfqemq")
    public suspend fun secretKey(`value`: Output<String>) {
        this.secretKey = value
    }

    /**
     * @param value Platform credential API key from Baidu.
     */
    @JvmName("rkrprgaxnlgethmt")
    public suspend fun apiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value The application ID.
     */
    @JvmName("rpbapxvfnwgobumt")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Specifies whether to enable the channel. Defaults to `true`.
     */
    @JvmName("ryesdhnxqxhewsla")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Platform credential Secret key from Baidu.
     */
    @JvmName("glmomgrqhnwdxgeb")
    public suspend fun secretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    internal fun build(): BaiduChannelArgs = BaiduChannelArgs(
        apiKey = apiKey,
        applicationId = applicationId,
        enabled = enabled,
        secretKey = secretKey,
    )
}
