@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EmailChannel].
 */
@PulumiTagMarker
public class EmailChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailChannelArgs = EmailChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailChannelArgsBuilder.() -> Unit) {
        val builder = EmailChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EmailChannel {
        val builtJavaResource = com.pulumi.aws.pinpoint.EmailChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EmailChannel(builtJavaResource)
    }
}

/**
 * Provides a Pinpoint Email Channel resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const app = new aws.pinpoint.App("app", {});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["pinpoint&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const role = new aws.iam.Role("role", {assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json)});
 * const email = new aws.pinpoint.EmailChannel("email", {
 *     applicationId: app.applicationId,
 *     fromAddress: "user@example.com",
 *     roleArn: role.arn,
 * });
 * const identity = new aws.ses.DomainIdentity("identity", {domain: "example.com"});
 * const rolePolicy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: [
 *             "mobileanalytics:PutEvents",
 *             "mobileanalytics:PutItems",
 *         ],
 *         resources: ["*"],
 *     }],
 * });
 * const rolePolicyRolePolicy = new aws.iam.RolePolicy("role_policy", {
 *     name: "role_policy",
 *     role: role.id,
 *     policy: rolePolicy.then(rolePolicy => rolePolicy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * app = aws.pinpoint.App("app")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["pinpoint&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * role = aws.iam.Role("role", assume_role_policy=assume_role.json)
 * email = aws.pinpoint.EmailChannel("email",
 *     application_id=app.application_id,
 *     from_address="user@example.com",
 *     role_arn=role.arn)
 * identity = aws.ses.DomainIdentity("identity", domain="example.com")
 * role_policy = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": [
 *         "mobileanalytics:PutEvents",
 *         "mobileanalytics:PutItems",
 *     ],
 *     "resources": ["*"],
 * }])
 * role_policy_role_policy = aws.iam.RolePolicy("role_policy",
 *     name="role_policy",
 *     role=role.id,
 *     policy=role_policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new Aws.Pinpoint.App("app");
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "pinpoint.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var role = new Aws.Iam.Role("role", new()
 *     {
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var email = new Aws.Pinpoint.EmailChannel("email", new()
 *     {
 *         ApplicationId = app.ApplicationId,
 *         FromAddress = "user@example.com",
 *         RoleArn = role.Arn,
 *     });
 *     var identity = new Aws.Ses.DomainIdentity("identity", new()
 *     {
 *         Domain = "example.com",
 *     });
 *     var rolePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "mobileanalytics:PutEvents",
 *                     "mobileanalytics:PutItems",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var rolePolicyRolePolicy = new Aws.Iam.RolePolicy("role_policy", new()
 *     {
 *         Name = "role_policy",
 *         Role = role.Id,
 *         Policy = rolePolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/pinpoint"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		app, err := pinpoint.NewApp(ctx, "app", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"pinpoint.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		role, err := iam.NewRole(ctx, "role", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pinpoint.NewEmailChannel(ctx, "email", &pinpoint.EmailChannelArgs{
 * 			ApplicationId: app.ApplicationId,
 * 			FromAddress:   pulumi.String("user@example.com"),
 * 			RoleArn:       role.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ses.NewDomainIdentity(ctx, "identity", &ses.DomainIdentityArgs{
 * 			Domain: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		rolePolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"mobileanalytics:PutEvents",
 * 						"mobileanalytics:PutItems",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicy(ctx, "role_policy", &iam.RolePolicyArgs{
 * 			Name:   pulumi.String("role_policy"),
 * 			Role:   role.ID(),
 * 			Policy: pulumi.String(rolePolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.pinpoint.EmailChannel;
 * import com.pulumi.aws.pinpoint.EmailChannelArgs;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("pinpoint.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var email = new EmailChannel("email", EmailChannelArgs.builder()
 *             .applicationId(app.applicationId())
 *             .fromAddress("user@example.com")
 *             .roleArn(role.arn())
 *             .build());
 *         var identity = new DomainIdentity("identity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         final var rolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "mobileanalytics:PutEvents",
 *                     "mobileanalytics:PutItems")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var rolePolicyRolePolicy = new RolePolicy("rolePolicyRolePolicy", RolePolicyArgs.builder()
 *             .name("role_policy")
 *             .role(role.id())
 *             .policy(rolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   email:
 *     type: aws:pinpoint:EmailChannel
 *     properties:
 *       applicationId: ${app.applicationId}
 *       fromAddress: user@example.com
 *       roleArn: ${role.arn}
 *   app:
 *     type: aws:pinpoint:App
 *   identity:
 *     type: aws:ses:DomainIdentity
 *     properties:
 *       domain: example.com
 *   role:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${assumeRole.json}
 *   rolePolicyRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: role_policy
 *     properties:
 *       name: role_policy
 *       role: ${role.id}
 *       policy: ${rolePolicy.json}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - pinpoint.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   rolePolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - mobileanalytics:PutEvents
 *               - mobileanalytics:PutItems
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Pinpoint Email Channel using the `application-id`. For example:
 * ```sh
 * $ pulumi import aws:pinpoint/emailChannel:EmailChannel email application-id
 * ```
 */
public class EmailChannel internal constructor(
    override val javaResource: com.pulumi.aws.pinpoint.EmailChannel,
) : KotlinCustomResource(javaResource, EmailChannelMapper) {
    /**
     * The application ID.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Amazon SES configuration set that you want to apply to messages that you send through the channel.
     */
    public val configurationSet: Output<String>?
        get() = javaResource.configurationSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the channel is enabled or disabled. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The email address used to send emails from. You can use email only (`user@example.com`) or friendly address (`User <user@example.com>`). This field comply with [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt).
     */
    public val fromAddress: Output<String>
        get() = javaResource.fromAddress().applyValue({ args0 -> args0 })

    /**
     * The ARN of an identity verified with SES.
     */
    public val identity: Output<String>
        get() = javaResource.identity().applyValue({ args0 -> args0 })

    /**
     * Messages per second that can be sent.
     */
    public val messagesPerSecond: Output<Int>
        get() = javaResource.messagesPerSecond().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EmailChannelMapper : ResourceMapper<EmailChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.pinpoint.EmailChannel::class == javaResource::class

    override fun map(javaResource: Resource): EmailChannel = EmailChannel(
        javaResource as
            com.pulumi.aws.pinpoint.EmailChannel,
    )
}

/**
 * @see [EmailChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailChannel].
 */
public suspend fun emailChannel(
    name: String,
    block: suspend EmailChannelResourceBuilder.() -> Unit,
): EmailChannel {
    val builder = EmailChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailChannel(name: String): EmailChannel {
    val builder = EmailChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
