@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pinpoint.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lambdaFunctionName Lambda function name or ARN to be called for delivery. Conflicts with `web_url`
 * @property mode What mode Lambda should be invoked in. Valid values for this parameter are `DELIVERY`, `FILTER`.
 * @property webUrl Web URL to call for hook. If the URL has authentication specified it will be added as authentication to the request. Conflicts with `lambda_function_name`
 */
public data class AppCampaignHook(
    public val lambdaFunctionName: String? = null,
    public val mode: String? = null,
    public val webUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pinpoint.outputs.AppCampaignHook): AppCampaignHook = AppCampaignHook(
            lambdaFunctionName = javaType.lambdaFunctionName().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            webUrl = javaType.webUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
