@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property httpParameters Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination. If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence. Detailed below.
 * @property inputTemplate Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
 */
public data class PipeEnrichmentParametersArgs(
    public val httpParameters: Output<PipeEnrichmentParametersHttpParametersArgs>? = null,
    public val inputTemplate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersArgs.builder()
            .httpParameters(httpParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputTemplate(inputTemplate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeEnrichmentParametersArgs].
 */
@PulumiTagMarker
public class PipeEnrichmentParametersArgsBuilder internal constructor() {
    private var httpParameters: Output<PipeEnrichmentParametersHttpParametersArgs>? = null

    private var inputTemplate: Output<String>? = null

    /**
     * @param value Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination. If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence. Detailed below.
     */
    @JvmName("aixwywnxburxkhyb")
    public suspend fun httpParameters(`value`: Output<PipeEnrichmentParametersHttpParametersArgs>) {
        this.httpParameters = value
    }

    /**
     * @param value Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
     */
    @JvmName("ewrrfarhoghdkwya")
    public suspend fun inputTemplate(`value`: Output<String>) {
        this.inputTemplate = value
    }

    /**
     * @param value Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination. If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence. Detailed below.
     */
    @JvmName("wegdqmyehmovxmih")
    public suspend fun httpParameters(`value`: PipeEnrichmentParametersHttpParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpParameters = mapped
    }

    /**
     * @param argument Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination. If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence. Detailed below.
     */
    @JvmName("lurpwokoqqoumgjl")
    public suspend fun httpParameters(argument: suspend PipeEnrichmentParametersHttpParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeEnrichmentParametersHttpParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.httpParameters = mapped
    }

    /**
     * @param value Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
     */
    @JvmName("qajwvcqpjoukfuyf")
    public suspend fun inputTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputTemplate = mapped
    }

    internal fun build(): PipeEnrichmentParametersArgs = PipeEnrichmentParametersArgs(
        httpParameters = httpParameters,
        inputTemplate = inputTemplate,
    )
}
