@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersHttpParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property headerParameters
 * @property pathParameterValues
 * @property queryStringParameters
 */
public data class PipeEnrichmentParametersHttpParametersArgs(
    public val headerParameters: Output<Map<String, String>>? = null,
    public val pathParameterValues: Output<String>? = null,
    public val queryStringParameters: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersHttpParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersHttpParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeEnrichmentParametersHttpParametersArgs.builder()
            .headerParameters(
                headerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .pathParameterValues(pathParameterValues?.applyValue({ args0 -> args0 }))
            .queryStringParameters(
                queryStringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipeEnrichmentParametersHttpParametersArgs].
 */
@PulumiTagMarker
public class PipeEnrichmentParametersHttpParametersArgsBuilder internal constructor() {
    private var headerParameters: Output<Map<String, String>>? = null

    private var pathParameterValues: Output<String>? = null

    private var queryStringParameters: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("kpbhygorcnxrcdyg")
    public suspend fun headerParameters(`value`: Output<Map<String, String>>) {
        this.headerParameters = value
    }

    /**
     * @param value
     */
    @JvmName("xycpryxjyamlfgbj")
    public suspend fun pathParameterValues(`value`: Output<String>) {
        this.pathParameterValues = value
    }

    /**
     * @param value
     */
    @JvmName("rxglnwjiexlrremh")
    public suspend fun queryStringParameters(`value`: Output<Map<String, String>>) {
        this.queryStringParameters = value
    }

    /**
     * @param value
     */
    @JvmName("xmnsuqoipaayljmx")
    public suspend fun headerParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param values
     */
    @JvmName("iyjshfgibcogcrmr")
    public fun headerParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param value
     */
    @JvmName("lyjuwlvwbobylstm")
    public suspend fun pathParameterValues(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathParameterValues = mapped
    }

    /**
     * @param value
     */
    @JvmName("djgovwlbgmrlgnix")
    public suspend fun queryStringParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    /**
     * @param values
     */
    @JvmName("mvbjlpdhujwkdfej")
    public fun queryStringParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    internal fun build(): PipeEnrichmentParametersHttpParametersArgs =
        PipeEnrichmentParametersHttpParametersArgs(
            headerParameters = headerParameters,
            pathParameterValues = pathParameterValues,
            queryStringParameters = queryStringParameters,
        )
}
