@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogsLogDestination Amazon CloudWatch Logs logging configuration settings for the pipe. Detailed below.
 * @property firehoseLogDestination Amazon Kinesis Data Firehose logging configuration settings for the pipe. Detailed below.
 * @property includeExecutionDatas String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
 * @property level The level of logging detail to include. Valid values `OFF`, `ERROR`, `INFO` and `TRACE`.
 * @property s3LogDestination Amazon S3 logging configuration settings for the pipe. Detailed below.
 */
public data class PipeLogConfigurationArgs(
    public val cloudwatchLogsLogDestination: Output<PipeLogConfigurationCloudwatchLogsLogDestinationArgs>? = null,
    public val firehoseLogDestination: Output<PipeLogConfigurationFirehoseLogDestinationArgs>? = null,
    public val includeExecutionDatas: Output<List<String>>? = null,
    public val level: Output<String>,
    public val s3LogDestination: Output<PipeLogConfigurationS3LogDestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeLogConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeLogConfigurationArgs =
        com.pulumi.aws.pipes.inputs.PipeLogConfigurationArgs.builder()
            .cloudwatchLogsLogDestination(
                cloudwatchLogsLogDestination?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .firehoseLogDestination(
                firehoseLogDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .includeExecutionDatas(includeExecutionDatas?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .level(level.applyValue({ args0 -> args0 }))
            .s3LogDestination(
                s3LogDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeLogConfigurationArgs].
 */
@PulumiTagMarker
public class PipeLogConfigurationArgsBuilder internal constructor() {
    private var cloudwatchLogsLogDestination:
        Output<PipeLogConfigurationCloudwatchLogsLogDestinationArgs>? = null

    private var firehoseLogDestination: Output<PipeLogConfigurationFirehoseLogDestinationArgs>? = null

    private var includeExecutionDatas: Output<List<String>>? = null

    private var level: Output<String>? = null

    private var s3LogDestination: Output<PipeLogConfigurationS3LogDestinationArgs>? = null

    /**
     * @param value Amazon CloudWatch Logs logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("gbcysekigyklvldb")
    public suspend fun cloudwatchLogsLogDestination(`value`: Output<PipeLogConfigurationCloudwatchLogsLogDestinationArgs>) {
        this.cloudwatchLogsLogDestination = value
    }

    /**
     * @param value Amazon Kinesis Data Firehose logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("yyiuvtcxlelgwbsl")
    public suspend fun firehoseLogDestination(`value`: Output<PipeLogConfigurationFirehoseLogDestinationArgs>) {
        this.firehoseLogDestination = value
    }

    /**
     * @param value String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
     */
    @JvmName("vxytuhmiksuciufu")
    public suspend fun includeExecutionDatas(`value`: Output<List<String>>) {
        this.includeExecutionDatas = value
    }

    @JvmName("ssufsrwsxrglclow")
    public suspend fun includeExecutionDatas(vararg values: Output<String>) {
        this.includeExecutionDatas = Output.all(values.asList())
    }

    /**
     * @param values String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
     */
    @JvmName("emhuhnpoorvfakjl")
    public suspend fun includeExecutionDatas(values: List<Output<String>>) {
        this.includeExecutionDatas = Output.all(values)
    }

    /**
     * @param value The level of logging detail to include. Valid values `OFF`, `ERROR`, `INFO` and `TRACE`.
     */
    @JvmName("ptmduximootsyuif")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value Amazon S3 logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("davcbobmhvskjcnk")
    public suspend fun s3LogDestination(`value`: Output<PipeLogConfigurationS3LogDestinationArgs>) {
        this.s3LogDestination = value
    }

    /**
     * @param value Amazon CloudWatch Logs logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("ditlrbuohyqjjkua")
    public suspend fun cloudwatchLogsLogDestination(`value`: PipeLogConfigurationCloudwatchLogsLogDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogsLogDestination = mapped
    }

    /**
     * @param argument Amazon CloudWatch Logs logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("sgymxmaxljnmwoqb")
    public suspend fun cloudwatchLogsLogDestination(argument: suspend PipeLogConfigurationCloudwatchLogsLogDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = PipeLogConfigurationCloudwatchLogsLogDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogsLogDestination = mapped
    }

    /**
     * @param value Amazon Kinesis Data Firehose logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("lwnjoyadvtibeear")
    public suspend fun firehoseLogDestination(`value`: PipeLogConfigurationFirehoseLogDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoseLogDestination = mapped
    }

    /**
     * @param argument Amazon Kinesis Data Firehose logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("ncjxigqvjoiqxtkc")
    public suspend fun firehoseLogDestination(argument: suspend PipeLogConfigurationFirehoseLogDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = PipeLogConfigurationFirehoseLogDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.firehoseLogDestination = mapped
    }

    /**
     * @param value String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
     */
    @JvmName("ntimddruooiewvyo")
    public suspend fun includeExecutionDatas(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeExecutionDatas = mapped
    }

    /**
     * @param values String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
     */
    @JvmName("ccwnxsglqullbaep")
    public suspend fun includeExecutionDatas(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeExecutionDatas = mapped
    }

    /**
     * @param value The level of logging detail to include. Valid values `OFF`, `ERROR`, `INFO` and `TRACE`.
     */
    @JvmName("tlbttmqwcaesxxsq")
    public suspend fun level(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Amazon S3 logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("sfrgfbagqxaacxiv")
    public suspend fun s3LogDestination(`value`: PipeLogConfigurationS3LogDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3LogDestination = mapped
    }

    /**
     * @param argument Amazon S3 logging configuration settings for the pipe. Detailed below.
     */
    @JvmName("otwmcbagqtfnsytv")
    public suspend fun s3LogDestination(argument: suspend PipeLogConfigurationS3LogDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = PipeLogConfigurationS3LogDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3LogDestination = mapped
    }

    internal fun build(): PipeLogConfigurationArgs = PipeLogConfigurationArgs(
        cloudwatchLogsLogDestination = cloudwatchLogsLogDestination,
        firehoseLogDestination = firehoseLogDestination,
        includeExecutionDatas = includeExecutionDatas,
        level = level ?: throw PulumiNullFieldException("level"),
        s3LogDestination = s3LogDestination,
    )
}
