@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeLogConfigurationCloudwatchLogsLogDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupArn Amazon Web Services Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.
 */
public data class PipeLogConfigurationCloudwatchLogsLogDestinationArgs(
    public val logGroupArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeLogConfigurationCloudwatchLogsLogDestinationArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeLogConfigurationCloudwatchLogsLogDestinationArgs =
        com.pulumi.aws.pipes.inputs.PipeLogConfigurationCloudwatchLogsLogDestinationArgs.builder()
            .logGroupArn(logGroupArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeLogConfigurationCloudwatchLogsLogDestinationArgs].
 */
@PulumiTagMarker
public class PipeLogConfigurationCloudwatchLogsLogDestinationArgsBuilder internal constructor() {
    private var logGroupArn: Output<String>? = null

    /**
     * @param value Amazon Web Services Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.
     */
    @JvmName("facrdjfxltdqbcqh")
    public suspend fun logGroupArn(`value`: Output<String>) {
        this.logGroupArn = value
    }

    /**
     * @param value Amazon Web Services Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.
     */
    @JvmName("uyxmgpnqiydipbab")
    public suspend fun logGroupArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupArn = mapped
    }

    internal fun build(): PipeLogConfigurationCloudwatchLogsLogDestinationArgs =
        PipeLogConfigurationCloudwatchLogsLogDestinationArgs(
            logGroupArn = logGroupArn ?: throw PulumiNullFieldException("logGroupArn"),
        )
}
