@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeLogConfigurationFirehoseLogDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryStreamArn Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge delivers the pipe log records.
 */
public data class PipeLogConfigurationFirehoseLogDestinationArgs(
    public val deliveryStreamArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeLogConfigurationFirehoseLogDestinationArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeLogConfigurationFirehoseLogDestinationArgs = com.pulumi.aws.pipes.inputs.PipeLogConfigurationFirehoseLogDestinationArgs.builder()
        .deliveryStreamArn(deliveryStreamArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeLogConfigurationFirehoseLogDestinationArgs].
 */
@PulumiTagMarker
public class PipeLogConfigurationFirehoseLogDestinationArgsBuilder internal constructor() {
    private var deliveryStreamArn: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge delivers the pipe log records.
     */
    @JvmName("ddmdudpsklbskfdv")
    public suspend fun deliveryStreamArn(`value`: Output<String>) {
        this.deliveryStreamArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge delivers the pipe log records.
     */
    @JvmName("mxpldtcfronddwly")
    public suspend fun deliveryStreamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryStreamArn = mapped
    }

    internal fun build(): PipeLogConfigurationFirehoseLogDestinationArgs =
        PipeLogConfigurationFirehoseLogDestinationArgs(
            deliveryStreamArn = deliveryStreamArn ?: throw PulumiNullFieldException("deliveryStreamArn"),
        )
}
