@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeLogConfigurationS3LogDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
 * @property bucketOwner Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
 * @property outputFormat EventBridge format for the log records. Valid values `json`, `plain` and `w3c`.
 * @property prefix Prefix text with which to begin Amazon S3 log object names.
 */
public data class PipeLogConfigurationS3LogDestinationArgs(
    public val bucketName: Output<String>,
    public val bucketOwner: Output<String>,
    public val outputFormat: Output<String>? = null,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeLogConfigurationS3LogDestinationArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeLogConfigurationS3LogDestinationArgs =
        com.pulumi.aws.pipes.inputs.PipeLogConfigurationS3LogDestinationArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketOwner(bucketOwner.applyValue({ args0 -> args0 }))
            .outputFormat(outputFormat?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeLogConfigurationS3LogDestinationArgs].
 */
@PulumiTagMarker
public class PipeLogConfigurationS3LogDestinationArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketOwner: Output<String>? = null

    private var outputFormat: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value Name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
     */
    @JvmName("jsxbgunikgwcfmqy")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
     */
    @JvmName("tflqrdbtmwsqtgma")
    public suspend fun bucketOwner(`value`: Output<String>) {
        this.bucketOwner = value
    }

    /**
     * @param value EventBridge format for the log records. Valid values `json`, `plain` and `w3c`.
     */
    @JvmName("cflrmpnsjkhuckvl")
    public suspend fun outputFormat(`value`: Output<String>) {
        this.outputFormat = value
    }

    /**
     * @param value Prefix text with which to begin Amazon S3 log object names.
     */
    @JvmName("dsapshripdtyurhi")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
     */
    @JvmName("eeorevcqhqofgihb")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
     */
    @JvmName("layiquwqmeqecomc")
    public suspend fun bucketOwner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketOwner = mapped
    }

    /**
     * @param value EventBridge format for the log records. Valid values `json`, `plain` and `w3c`.
     */
    @JvmName("oogdpqkkpxgndvjh")
    public suspend fun outputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputFormat = mapped
    }

    /**
     * @param value Prefix text with which to begin Amazon S3 log object names.
     */
    @JvmName("fwlukamhuxxhdeba")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): PipeLogConfigurationS3LogDestinationArgs =
        PipeLogConfigurationS3LogDestinationArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            bucketOwner = bucketOwner ?: throw PulumiNullFieldException("bucketOwner"),
            outputFormat = outputFormat,
            prefix = prefix,
        )
}
