@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property activemqBrokerParameters The parameters for using an Active MQ broker as a source. Detailed below.
 * @property dynamodbStreamParameters The parameters for using a DynamoDB stream as a source.  Detailed below.
 * @property filterCriteria The collection of event patterns used to [filter events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-filtering.html). Detailed below.
 * @property kinesisStreamParameters The parameters for using a Kinesis stream as a source. Detailed below.
 * @property managedStreamingKafkaParameters The parameters for using an MSK stream as a source. Detailed below.
 * @property rabbitmqBrokerParameters The parameters for using a Rabbit MQ broker as a source. Detailed below.
 * @property selfManagedKafkaParameters The parameters for using a self-managed Apache Kafka stream as a source. Detailed below.
 * @property sqsQueueParameters The parameters for using a Amazon SQS stream as a source. Detailed below.
 */
public data class PipeSourceParametersArgs(
    public val activemqBrokerParameters: Output<PipeSourceParametersActivemqBrokerParametersArgs>? =
        null,
    public val dynamodbStreamParameters: Output<PipeSourceParametersDynamodbStreamParametersArgs>? =
        null,
    public val filterCriteria: Output<PipeSourceParametersFilterCriteriaArgs>? = null,
    public val kinesisStreamParameters: Output<PipeSourceParametersKinesisStreamParametersArgs>? =
        null,
    public val managedStreamingKafkaParameters: Output<PipeSourceParametersManagedStreamingKafkaParametersArgs>? = null,
    public val rabbitmqBrokerParameters: Output<PipeSourceParametersRabbitmqBrokerParametersArgs>? =
        null,
    public val selfManagedKafkaParameters: Output<PipeSourceParametersSelfManagedKafkaParametersArgs>? =
        null,
    public val sqsQueueParameters: Output<PipeSourceParametersSqsQueueParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersArgs.builder()
            .activemqBrokerParameters(
                activemqBrokerParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dynamodbStreamParameters(
                dynamodbStreamParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filterCriteria(filterCriteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kinesisStreamParameters(
                kinesisStreamParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .managedStreamingKafkaParameters(
                managedStreamingKafkaParameters?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .rabbitmqBrokerParameters(
                rabbitmqBrokerParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .selfManagedKafkaParameters(
                selfManagedKafkaParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqsQueueParameters(
                sqsQueueParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeSourceParametersArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersArgsBuilder internal constructor() {
    private var activemqBrokerParameters: Output<PipeSourceParametersActivemqBrokerParametersArgs>? =
        null

    private var dynamodbStreamParameters: Output<PipeSourceParametersDynamodbStreamParametersArgs>? =
        null

    private var filterCriteria: Output<PipeSourceParametersFilterCriteriaArgs>? = null

    private var kinesisStreamParameters: Output<PipeSourceParametersKinesisStreamParametersArgs>? =
        null

    private var managedStreamingKafkaParameters:
        Output<PipeSourceParametersManagedStreamingKafkaParametersArgs>? = null

    private var rabbitmqBrokerParameters: Output<PipeSourceParametersRabbitmqBrokerParametersArgs>? =
        null

    private var selfManagedKafkaParameters:
        Output<PipeSourceParametersSelfManagedKafkaParametersArgs>? = null

    private var sqsQueueParameters: Output<PipeSourceParametersSqsQueueParametersArgs>? = null

    /**
     * @param value The parameters for using an Active MQ broker as a source. Detailed below.
     */
    @JvmName("gtlgslmnavhlvhjw")
    public suspend fun activemqBrokerParameters(`value`: Output<PipeSourceParametersActivemqBrokerParametersArgs>) {
        this.activemqBrokerParameters = value
    }

    /**
     * @param value The parameters for using a DynamoDB stream as a source.  Detailed below.
     */
    @JvmName("xbxrmvchsrcwuvmg")
    public suspend fun dynamodbStreamParameters(`value`: Output<PipeSourceParametersDynamodbStreamParametersArgs>) {
        this.dynamodbStreamParameters = value
    }

    /**
     * @param value The collection of event patterns used to [filter events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-filtering.html). Detailed below.
     */
    @JvmName("hvnncgpnfekuimkk")
    public suspend fun filterCriteria(`value`: Output<PipeSourceParametersFilterCriteriaArgs>) {
        this.filterCriteria = value
    }

    /**
     * @param value The parameters for using a Kinesis stream as a source. Detailed below.
     */
    @JvmName("ucdtdiopvombgydo")
    public suspend fun kinesisStreamParameters(`value`: Output<PipeSourceParametersKinesisStreamParametersArgs>) {
        this.kinesisStreamParameters = value
    }

    /**
     * @param value The parameters for using an MSK stream as a source. Detailed below.
     */
    @JvmName("rasdqpfkruivorne")
    public suspend fun managedStreamingKafkaParameters(`value`: Output<PipeSourceParametersManagedStreamingKafkaParametersArgs>) {
        this.managedStreamingKafkaParameters = value
    }

    /**
     * @param value The parameters for using a Rabbit MQ broker as a source. Detailed below.
     */
    @JvmName("culvaqlfmnihnkbr")
    public suspend fun rabbitmqBrokerParameters(`value`: Output<PipeSourceParametersRabbitmqBrokerParametersArgs>) {
        this.rabbitmqBrokerParameters = value
    }

    /**
     * @param value The parameters for using a self-managed Apache Kafka stream as a source. Detailed below.
     */
    @JvmName("mgulyeaoowrsjnkn")
    public suspend fun selfManagedKafkaParameters(`value`: Output<PipeSourceParametersSelfManagedKafkaParametersArgs>) {
        this.selfManagedKafkaParameters = value
    }

    /**
     * @param value The parameters for using a Amazon SQS stream as a source. Detailed below.
     */
    @JvmName("amkeaijhiiasuwtu")
    public suspend fun sqsQueueParameters(`value`: Output<PipeSourceParametersSqsQueueParametersArgs>) {
        this.sqsQueueParameters = value
    }

    /**
     * @param value The parameters for using an Active MQ broker as a source. Detailed below.
     */
    @JvmName("qxweshniusoajbpx")
    public suspend fun activemqBrokerParameters(`value`: PipeSourceParametersActivemqBrokerParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activemqBrokerParameters = mapped
    }

    /**
     * @param argument The parameters for using an Active MQ broker as a source. Detailed below.
     */
    @JvmName("yjybjxpsktyderkq")
    public suspend fun activemqBrokerParameters(argument: suspend PipeSourceParametersActivemqBrokerParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersActivemqBrokerParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.activemqBrokerParameters = mapped
    }

    /**
     * @param value The parameters for using a DynamoDB stream as a source.  Detailed below.
     */
    @JvmName("jkvakeviqkfusnka")
    public suspend fun dynamodbStreamParameters(`value`: PipeSourceParametersDynamodbStreamParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbStreamParameters = mapped
    }

    /**
     * @param argument The parameters for using a DynamoDB stream as a source.  Detailed below.
     */
    @JvmName("nphjotxlwfjpyham")
    public suspend fun dynamodbStreamParameters(argument: suspend PipeSourceParametersDynamodbStreamParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersDynamodbStreamParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dynamodbStreamParameters = mapped
    }

    /**
     * @param value The collection of event patterns used to [filter events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-filtering.html). Detailed below.
     */
    @JvmName("butafdxfpeytgutj")
    public suspend fun filterCriteria(`value`: PipeSourceParametersFilterCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterCriteria = mapped
    }

    /**
     * @param argument The collection of event patterns used to [filter events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-filtering.html). Detailed below.
     */
    @JvmName("jrrlfcxukkveqowk")
    public suspend fun filterCriteria(argument: suspend PipeSourceParametersFilterCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersFilterCriteriaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filterCriteria = mapped
    }

    /**
     * @param value The parameters for using a Kinesis stream as a source. Detailed below.
     */
    @JvmName("nyayrhongtskxige")
    public suspend fun kinesisStreamParameters(`value`: PipeSourceParametersKinesisStreamParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisStreamParameters = mapped
    }

    /**
     * @param argument The parameters for using a Kinesis stream as a source. Detailed below.
     */
    @JvmName("vofxascgnikkxqqi")
    public suspend fun kinesisStreamParameters(argument: suspend PipeSourceParametersKinesisStreamParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersKinesisStreamParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisStreamParameters = mapped
    }

    /**
     * @param value The parameters for using an MSK stream as a source. Detailed below.
     */
    @JvmName("xwdsstpqciyswxsd")
    public suspend fun managedStreamingKafkaParameters(`value`: PipeSourceParametersManagedStreamingKafkaParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedStreamingKafkaParameters = mapped
    }

    /**
     * @param argument The parameters for using an MSK stream as a source. Detailed below.
     */
    @JvmName("pgfavvvcwhgaunrn")
    public suspend fun managedStreamingKafkaParameters(argument: suspend PipeSourceParametersManagedStreamingKafkaParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersManagedStreamingKafkaParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedStreamingKafkaParameters = mapped
    }

    /**
     * @param value The parameters for using a Rabbit MQ broker as a source. Detailed below.
     */
    @JvmName("hsmwrsuwwaoingps")
    public suspend fun rabbitmqBrokerParameters(`value`: PipeSourceParametersRabbitmqBrokerParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rabbitmqBrokerParameters = mapped
    }

    /**
     * @param argument The parameters for using a Rabbit MQ broker as a source. Detailed below.
     */
    @JvmName("sknogxetchnlsypc")
    public suspend fun rabbitmqBrokerParameters(argument: suspend PipeSourceParametersRabbitmqBrokerParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersRabbitmqBrokerParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rabbitmqBrokerParameters = mapped
    }

    /**
     * @param value The parameters for using a self-managed Apache Kafka stream as a source. Detailed below.
     */
    @JvmName("ftimbhcxhvlgdrol")
    public suspend fun selfManagedKafkaParameters(`value`: PipeSourceParametersSelfManagedKafkaParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfManagedKafkaParameters = mapped
    }

    /**
     * @param argument The parameters for using a self-managed Apache Kafka stream as a source. Detailed below.
     */
    @JvmName("rsnuduypawvcpkuj")
    public suspend fun selfManagedKafkaParameters(argument: suspend PipeSourceParametersSelfManagedKafkaParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersSelfManagedKafkaParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.selfManagedKafkaParameters = mapped
    }

    /**
     * @param value The parameters for using a Amazon SQS stream as a source. Detailed below.
     */
    @JvmName("lnttsolloklwwvmw")
    public suspend fun sqsQueueParameters(`value`: PipeSourceParametersSqsQueueParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsQueueParameters = mapped
    }

    /**
     * @param argument The parameters for using a Amazon SQS stream as a source. Detailed below.
     */
    @JvmName("jxdpotwuwyshmqnm")
    public suspend fun sqsQueueParameters(argument: suspend PipeSourceParametersSqsQueueParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeSourceParametersSqsQueueParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sqsQueueParameters = mapped
    }

    internal fun build(): PipeSourceParametersArgs = PipeSourceParametersArgs(
        activemqBrokerParameters = activemqBrokerParameters,
        dynamodbStreamParameters = dynamodbStreamParameters,
        filterCriteria = filterCriteria,
        kinesisStreamParameters = kinesisStreamParameters,
        managedStreamingKafkaParameters = managedStreamingKafkaParameters,
        rabbitmqBrokerParameters = rabbitmqBrokerParameters,
        selfManagedKafkaParameters = selfManagedKafkaParameters,
        sqsQueueParameters = sqsQueueParameters,
    )
}
