@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pattern The event pattern. At most 4096 characters.
 */
public data class PipeSourceParametersFilterCriteriaFilterArgs(
    public val pattern: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaFilterArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaFilterArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersFilterCriteriaFilterArgs.builder()
            .pattern(pattern.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersFilterCriteriaFilterArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersFilterCriteriaFilterArgsBuilder internal constructor() {
    private var pattern: Output<String>? = null

    /**
     * @param value The event pattern. At most 4096 characters.
     */
    @JvmName("fbunnmrddwgviymm")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value The event pattern. At most 4096 characters.
     */
    @JvmName("gdotbpsmmdtfomfb")
    public suspend fun pattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    internal fun build(): PipeSourceParametersFilterCriteriaFilterArgs =
        PipeSourceParametersFilterCriteriaFilterArgs(
            pattern = pattern ?: throw PulumiNullFieldException("pattern"),
        )
}
