@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of this pipe.
 */
public data class PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs(
    public val arn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value ARN of this pipe.
     */
    @JvmName("twjrimpxncxwqcys")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value ARN of this pipe.
     */
    @JvmName("dlrbmvgiokhdetrg")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs =
        PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs(
            arn = arn,
        )
}
