@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property consumerGroupId The name of the destination queue to consume. Maximum value of 200.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property startingPosition The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
 * @property topicName The name of the topic that the pipe will read from. Maximum length of 249.
 */
public data class PipeSourceParametersManagedStreamingKafkaParametersArgs(
    public val batchSize: Output<Int>? = null,
    public val consumerGroupId: Output<String>? = null,
    public val credentials: Output<PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs>? = null,
    public val maximumBatchingWindowInSeconds: Output<Int>? = null,
    public val startingPosition: Output<String>? = null,
    public val topicName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersArgs.builder()
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .consumerGroupId(consumerGroupId?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds?.applyValue({ args0 -> args0 }))
            .startingPosition(startingPosition?.applyValue({ args0 -> args0 }))
            .topicName(topicName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersManagedStreamingKafkaParametersArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersManagedStreamingKafkaParametersArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var consumerGroupId: Output<String>? = null

    private var credentials:
        Output<PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs>? = null

    private var maximumBatchingWindowInSeconds: Output<Int>? = null

    private var startingPosition: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("hvnpjfmkvgiavwqq")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value The name of the destination queue to consume. Maximum value of 200.
     */
    @JvmName("lnchfpxvyhsxuake")
    public suspend fun consumerGroupId(`value`: Output<String>) {
        this.consumerGroupId = value
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("mijmfqacmarbjuts")
    public suspend fun credentials(`value`: Output<PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("nktumwoqtyjalhwu")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Output<Int>) {
        this.maximumBatchingWindowInSeconds = value
    }

    /**
     * @param value The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
     */
    @JvmName("yyaoilroqsyhdqdx")
    public suspend fun startingPosition(`value`: Output<String>) {
        this.startingPosition = value
    }

    /**
     * @param value The name of the topic that the pipe will read from. Maximum length of 249.
     */
    @JvmName("jxrafojtlxqunirr")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("rjdeflmlrkjmpypv")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value The name of the destination queue to consume. Maximum value of 200.
     */
    @JvmName("anhmfehulyxjmlaj")
    public suspend fun consumerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupId = mapped
    }

    /**
     * @param value The credentials needed to access the resource. Detailed below.
     */
    @JvmName("ubdjwodmaednylsr")
    public suspend fun credentials(`value`: PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The credentials needed to access the resource. Detailed below.
     */
    @JvmName("htaxkqgckbkwamhe")
    public suspend fun credentials(argument: suspend PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("ojlkvmxsdwixwrxm")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBatchingWindowInSeconds = mapped
    }

    /**
     * @param value The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
     */
    @JvmName("qqnbgwwxbeuswkex")
    public suspend fun startingPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPosition = mapped
    }

    /**
     * @param value The name of the topic that the pipe will read from. Maximum length of 249.
     */
    @JvmName("aohlrstqtiikrtqs")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): PipeSourceParametersManagedStreamingKafkaParametersArgs =
        PipeSourceParametersManagedStreamingKafkaParametersArgs(
            batchSize = batchSize,
            consumerGroupId = consumerGroupId,
            credentials = credentials,
            maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds,
            startingPosition = startingPosition,
            topicName = topicName ?: throw PulumiNullFieldException("topicName"),
        )
}
