@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientCertificateTlsAuth The ARN of the Secrets Manager secret containing the credentials.
 * @property saslScram512Auth The ARN of the Secrets Manager secret containing the credentials.
 */
public data class PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs(
    public val clientCertificateTlsAuth: Output<String>? = null,
    public val saslScram512Auth: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs.builder()
            .clientCertificateTlsAuth(clientCertificateTlsAuth?.applyValue({ args0 -> args0 }))
            .saslScram512Auth(saslScram512Auth?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgsBuilder internal constructor() {
    private var clientCertificateTlsAuth: Output<String>? = null

    private var saslScram512Auth: Output<String>? = null

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("effhvniflpodcaav")
    public suspend fun clientCertificateTlsAuth(`value`: Output<String>) {
        this.clientCertificateTlsAuth = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("sckvlidbwohxtrpe")
    public suspend fun saslScram512Auth(`value`: Output<String>) {
        this.saslScram512Auth = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("oglouvaptmyudriu")
    public suspend fun clientCertificateTlsAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateTlsAuth = mapped
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("jpvfmcaomlsyynkd")
    public suspend fun saslScram512Auth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saslScram512Auth = mapped
    }

    internal fun build(): PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs =
        PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs(
            clientCertificateTlsAuth = clientCertificateTlsAuth,
            saslScram512Auth = saslScram512Auth,
        )
}
