@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property basicAuth The ARN of the Secrets Manager secret containing the credentials.
 */
public data class PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs(
    public val basicAuth: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs.builder()
            .basicAuth(basicAuth.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersRabbitmqBrokerParametersCredentialsArgsBuilder internal constructor() {
    private var basicAuth: Output<String>? = null

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("vwjyqwcrwhmedcyp")
    public suspend fun basicAuth(`value`: Output<String>) {
        this.basicAuth = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("kvisaorjbrvrgohr")
    public suspend fun basicAuth(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.basicAuth = mapped
    }

    internal fun build(): PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs =
        PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs(
            basicAuth = basicAuth ?: throw PulumiNullFieldException("basicAuth"),
        )
}
