@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property basicAuth The ARN of the Secrets Manager secret containing the credentials.
 * @property clientCertificateTlsAuth The ARN of the Secrets Manager secret containing the credentials.
 * @property saslScram256Auth The ARN of the Secrets Manager secret containing the credentials.
 * @property saslScram512Auth The ARN of the Secrets Manager secret containing the credentials.
 */
public data class PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs(
    public val basicAuth: Output<String>? = null,
    public val clientCertificateTlsAuth: Output<String>? = null,
    public val saslScram256Auth: Output<String>? = null,
    public val saslScram512Auth: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs.builder()
            .basicAuth(basicAuth?.applyValue({ args0 -> args0 }))
            .clientCertificateTlsAuth(clientCertificateTlsAuth?.applyValue({ args0 -> args0 }))
            .saslScram256Auth(saslScram256Auth?.applyValue({ args0 -> args0 }))
            .saslScram512Auth(saslScram512Auth?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersSelfManagedKafkaParametersCredentialsArgsBuilder internal constructor() {
    private var basicAuth: Output<String>? = null

    private var clientCertificateTlsAuth: Output<String>? = null

    private var saslScram256Auth: Output<String>? = null

    private var saslScram512Auth: Output<String>? = null

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("hfnamucwwwijneha")
    public suspend fun basicAuth(`value`: Output<String>) {
        this.basicAuth = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("xqxloqobixpqxltx")
    public suspend fun clientCertificateTlsAuth(`value`: Output<String>) {
        this.clientCertificateTlsAuth = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("pqqbrovjmpevsxfv")
    public suspend fun saslScram256Auth(`value`: Output<String>) {
        this.saslScram256Auth = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("tovevhrhqesecrmr")
    public suspend fun saslScram512Auth(`value`: Output<String>) {
        this.saslScram512Auth = value
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("cbsfjchccrmomcbs")
    public suspend fun basicAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuth = mapped
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("kddcwavklorbsrpf")
    public suspend fun clientCertificateTlsAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateTlsAuth = mapped
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("epsxffhwopeuajgh")
    public suspend fun saslScram256Auth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saslScram256Auth = mapped
    }

    /**
     * @param value The ARN of the Secrets Manager secret containing the credentials.
     */
    @JvmName("xccqwbjqgtkilwvl")
    public suspend fun saslScram512Auth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saslScram512Auth = mapped
    }

    internal fun build(): PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs =
        PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs(
            basicAuth = basicAuth,
            clientCertificateTlsAuth = clientCertificateTlsAuth,
            saslScram256Auth = saslScram256Auth,
            saslScram512Auth = saslScram512Auth,
        )
}
