@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroups
 * @property subnets
 */
public data class PipeSourceParametersSelfManagedKafkaParametersVpcArgs(
    public val securityGroups: Output<List<String>>? = null,
    public val subnets: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs.builder()
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PipeSourceParametersSelfManagedKafkaParametersVpcArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersSelfManagedKafkaParametersVpcArgsBuilder internal constructor() {
    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ogbmamlxtgpetxjr")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("jjcroqhretstyxlo")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("lapgacjcxpytjajk")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xcwwlmxoovobbuyk")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("hwuunsiafrgvuqhv")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ybyktibuigetojvq")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bvxggxhlbxggxcop")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values
     */
    @JvmName("awuqomsbjfgdeaqd")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value
     */
    @JvmName("tcmrgsgveqcoxhit")
    public suspend fun subnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values
     */
    @JvmName("ypofefvkhqswcxem")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): PipeSourceParametersSelfManagedKafkaParametersVpcArgs =
        PipeSourceParametersSelfManagedKafkaParametersVpcArgs(
            securityGroups = securityGroups,
            subnets = subnets,
        )
}
