@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersSqsQueueParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 */
public data class PipeSourceParametersSqsQueueParametersArgs(
    public val batchSize: Output<Int>? = null,
    public val maximumBatchingWindowInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersSqsQueueParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeSourceParametersSqsQueueParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersSqsQueueParametersArgs.builder()
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .maximumBatchingWindowInSeconds(
                maximumBatchingWindowInSeconds?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [PipeSourceParametersSqsQueueParametersArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersSqsQueueParametersArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var maximumBatchingWindowInSeconds: Output<Int>? = null

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("mbtgakfmtxydxlqd")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("vpqhhtgyxhitqymy")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Output<Int>) {
        this.maximumBatchingWindowInSeconds = value
    }

    /**
     * @param value The maximum number of records to include in each batch. Maximum value of 10000.
     */
    @JvmName("wvxnbaucdxcukuvg")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value The maximum length of a time to wait for events. Maximum value of 300.
     */
    @JvmName("blklixwnwwlnoduw")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBatchingWindowInSeconds = mapped
    }

    internal fun build(): PipeSourceParametersSqsQueueParametersArgs =
        PipeSourceParametersSqsQueueParametersArgs(
            batchSize = batchSize,
            maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds,
        )
}
