@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property arrayProperties The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job. Detailed below.
 * @property containerOverrides The overrides that are sent to a container. Detailed below.
 * @property dependsOns A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
 * @property jobDefinition The job definition used by this job. This value can be one of name, name:revision, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
 * @property jobName The name of the job. It can be up to 128 letters long.
 * @property parameters Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition. Detailed below.
 * @property retryStrategy The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Detailed below.
 */
public data class PipeTargetParametersBatchJobParametersArgs(
    public val arrayProperties: Output<PipeTargetParametersBatchJobParametersArrayPropertiesArgs>? =
        null,
    public val containerOverrides: Output<PipeTargetParametersBatchJobParametersContainerOverridesArgs>? = null,
    public val dependsOns: Output<List<PipeTargetParametersBatchJobParametersDependsOnArgs>>? = null,
    public val jobDefinition: Output<String>,
    public val jobName: Output<String>,
    public val parameters: Output<Map<String, String>>? = null,
    public val retryStrategy: Output<PipeTargetParametersBatchJobParametersRetryStrategyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArgs.builder()
            .arrayProperties(arrayProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerOverrides(
                containerOverrides?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dependsOns(
                dependsOns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .jobDefinition(jobDefinition.applyValue({ args0 -> args0 }))
            .jobName(jobName.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .retryStrategy(retryStrategy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipeTargetParametersBatchJobParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersBatchJobParametersArgsBuilder internal constructor() {
    private var arrayProperties: Output<PipeTargetParametersBatchJobParametersArrayPropertiesArgs>? =
        null

    private var containerOverrides:
        Output<PipeTargetParametersBatchJobParametersContainerOverridesArgs>? = null

    private var dependsOns: Output<List<PipeTargetParametersBatchJobParametersDependsOnArgs>>? = null

    private var jobDefinition: Output<String>? = null

    private var jobName: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var retryStrategy: Output<PipeTargetParametersBatchJobParametersRetryStrategyArgs>? = null

    /**
     * @param value The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job. Detailed below.
     */
    @JvmName("modkaipbhhjyjqeq")
    public suspend fun arrayProperties(`value`: Output<PipeTargetParametersBatchJobParametersArrayPropertiesArgs>) {
        this.arrayProperties = value
    }

    /**
     * @param value The overrides that are sent to a container. Detailed below.
     */
    @JvmName("sgwvrgyhptonrxso")
    public suspend fun containerOverrides(`value`: Output<PipeTargetParametersBatchJobParametersContainerOverridesArgs>) {
        this.containerOverrides = value
    }

    /**
     * @param value A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
     */
    @JvmName("xviuwjfsnmaqeplw")
    public suspend fun dependsOns(`value`: Output<List<PipeTargetParametersBatchJobParametersDependsOnArgs>>) {
        this.dependsOns = value
    }

    @JvmName("xidurbmkihaeucsl")
    public suspend fun dependsOns(vararg values: Output<PipeTargetParametersBatchJobParametersDependsOnArgs>) {
        this.dependsOns = Output.all(values.asList())
    }

    /**
     * @param values A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
     */
    @JvmName("ujoprtgofblsjkee")
    public suspend fun dependsOns(values: List<Output<PipeTargetParametersBatchJobParametersDependsOnArgs>>) {
        this.dependsOns = Output.all(values)
    }

    /**
     * @param value The job definition used by this job. This value can be one of name, name:revision, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
     */
    @JvmName("yaucdfnicenyrjvw")
    public suspend fun jobDefinition(`value`: Output<String>) {
        this.jobDefinition = value
    }

    /**
     * @param value The name of the job. It can be up to 128 letters long.
     */
    @JvmName("qmbiesurirtjudgp")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition. Detailed below.
     */
    @JvmName("fnfseokqksnorgjk")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Detailed below.
     */
    @JvmName("qynkknqbghdaqihs")
    public suspend fun retryStrategy(`value`: Output<PipeTargetParametersBatchJobParametersRetryStrategyArgs>) {
        this.retryStrategy = value
    }

    /**
     * @param value The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job. Detailed below.
     */
    @JvmName("hqixqjhoatmuerrn")
    public suspend fun arrayProperties(`value`: PipeTargetParametersBatchJobParametersArrayPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arrayProperties = mapped
    }

    /**
     * @param argument The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job. Detailed below.
     */
    @JvmName("djxnekjwjpmbofjb")
    public suspend fun arrayProperties(argument: suspend PipeTargetParametersBatchJobParametersArrayPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeTargetParametersBatchJobParametersArrayPropertiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.arrayProperties = mapped
    }

    /**
     * @param value The overrides that are sent to a container. Detailed below.
     */
    @JvmName("wqpbvfvdlxpxrmot")
    public suspend fun containerOverrides(`value`: PipeTargetParametersBatchJobParametersContainerOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerOverrides = mapped
    }

    /**
     * @param argument The overrides that are sent to a container. Detailed below.
     */
    @JvmName("naqgnfyfnhllognn")
    public suspend fun containerOverrides(argument: suspend PipeTargetParametersBatchJobParametersContainerOverridesArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeTargetParametersBatchJobParametersContainerOverridesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.containerOverrides = mapped
    }

    /**
     * @param value A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
     */
    @JvmName("jwvqbuuvejxvsdad")
    public suspend fun dependsOns(`value`: List<PipeTargetParametersBatchJobParametersDependsOnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOns = mapped
    }

    /**
     * @param argument A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
     */
    @JvmName("qjkdjnwepkejjdwu")
    public suspend fun dependsOns(argument: List<suspend PipeTargetParametersBatchJobParametersDependsOnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersBatchJobParametersDependsOnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOns = mapped
    }

    /**
     * @param argument A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
     */
    @JvmName("hwlltjbpcibuixip")
    public suspend fun dependsOns(vararg argument: suspend PipeTargetParametersBatchJobParametersDependsOnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersBatchJobParametersDependsOnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOns = mapped
    }

    /**
     * @param argument A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
     */
    @JvmName("sqbuhujxaxeoybnj")
    public suspend fun dependsOns(argument: suspend PipeTargetParametersBatchJobParametersDependsOnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersBatchJobParametersDependsOnArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.dependsOns = mapped
    }

    /**
     * @param values A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
     */
    @JvmName("ukncaywhixaffpoi")
    public suspend fun dependsOns(vararg values: PipeTargetParametersBatchJobParametersDependsOnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOns = mapped
    }

    /**
     * @param value The job definition used by this job. This value can be one of name, name:revision, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
     */
    @JvmName("gwefslhyljkelbwa")
    public suspend fun jobDefinition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobDefinition = mapped
    }

    /**
     * @param value The name of the job. It can be up to 128 letters long.
     */
    @JvmName("glhbkhxlugiwkeld")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition. Detailed below.
     */
    @JvmName("uquconrjxffwlyhb")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition. Detailed below.
     */
    @JvmName("ineksxphlsljvbwi")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Detailed below.
     */
    @JvmName("kmgscojdmitbbdmp")
    public suspend fun retryStrategy(`value`: PipeTargetParametersBatchJobParametersRetryStrategyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryStrategy = mapped
    }

    /**
     * @param argument The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Detailed below.
     */
    @JvmName("iyjjynytrhtxlhor")
    public suspend fun retryStrategy(argument: suspend PipeTargetParametersBatchJobParametersRetryStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersBatchJobParametersRetryStrategyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.retryStrategy = mapped
    }

    internal fun build(): PipeTargetParametersBatchJobParametersArgs =
        PipeTargetParametersBatchJobParametersArgs(
            arrayProperties = arrayProperties,
            containerOverrides = containerOverrides,
            dependsOns = dependsOns,
            jobDefinition = jobDefinition ?: throw PulumiNullFieldException("jobDefinition"),
            jobName = jobName ?: throw PulumiNullFieldException("jobName"),
            parameters = parameters,
            retryStrategy = retryStrategy,
        )
}
