@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property commands List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
 * @property environments The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
 * @property instanceType The instance type to use for a multi-node parallel job. This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
 * @property resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
 */
public data class PipeTargetParametersBatchJobParametersContainerOverridesArgs(
    public val commands: Output<List<String>>? = null,
    public val environments: Output<List<PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs>>? = null,
    public val instanceType: Output<String>? = null,
    public val resourceRequirements: Output<List<PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesArgs.builder()
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .environments(
                environments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .resourceRequirements(
                resourceRequirements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersBatchJobParametersContainerOverridesArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersBatchJobParametersContainerOverridesArgsBuilder internal constructor() {
    private var commands: Output<List<String>>? = null

    private var environments:
        Output<List<PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs>>? = null

    private var instanceType: Output<String>? = null

    private var resourceRequirements:
        Output<List<PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs>>? =
        null

    /**
     * @param value List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("alpiodjgmmjctlgb")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("ptytbawxyumojydy")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("gsllkhiixgxwbukg")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("plodnrwcxkpwxknn")
    public suspend fun environments(`value`: Output<List<PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs>>) {
        this.environments = value
    }

    @JvmName("ltiddrxxdcrmlcrd")
    public suspend fun environments(vararg values: Output<PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs>) {
        this.environments = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("ynaorimdwyoaqfdt")
    public suspend fun environments(values: List<Output<PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs>>) {
        this.environments = Output.all(values)
    }

    /**
     * @param value The instance type to use for a multi-node parallel job. This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
     */
    @JvmName("ewhvspqhsjmrhjvj")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("wbfmwnidvlqbbpqi")
    public suspend fun resourceRequirements(`value`: Output<List<PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs>>) {
        this.resourceRequirements = value
    }

    @JvmName("jpecilfawwxxigwp")
    public suspend fun resourceRequirements(vararg values: Output<PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs>) {
        this.resourceRequirements = Output.all(values.asList())
    }

    /**
     * @param values The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("cudwelyekxdvregq")
    public suspend fun resourceRequirements(values: List<Output<PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs>>) {
        this.resourceRequirements = Output.all(values)
    }

    /**
     * @param value List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("kjiqwalvhkqubujt")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("rbjcbdiaxgqqewrr")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("dnrnpfrwugtyikcx")
    public suspend fun environments(`value`: List<PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("ciunxdjfmpksjdqt")
    public suspend fun environments(argument: List<suspend PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("piareunvtefsembi")
    public suspend fun environments(vararg argument: suspend PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("gbaehdltjntxrqmm")
    public suspend fun environments(argument: suspend PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param values The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("yctiirmhojvsmaoh")
    public suspend fun environments(vararg values: PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param value The instance type to use for a multi-node parallel job. This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
     */
    @JvmName("uwbjsrmsjkelgsbg")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("okhqvllydwbrrooi")
    public suspend fun resourceRequirements(`value`: List<PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("ovqkjeoxuwfoqmpa")
    public suspend fun resourceRequirements(argument: List<suspend PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("vwbywsmxekdebbhn")
    public suspend fun resourceRequirements(vararg argument: suspend PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("nrayopqckcavriqq")
    public suspend fun resourceRequirements(argument: suspend PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param values The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("ojwbgjmsiedbqpuv")
    public suspend fun resourceRequirements(vararg values: PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceRequirements = mapped
    }

    internal fun build(): PipeTargetParametersBatchJobParametersContainerOverridesArgs =
        PipeTargetParametersBatchJobParametersContainerOverridesArgs(
            commands = commands,
            environments = environments,
            instanceType = instanceType,
            resourceRequirements = resourceRequirements,
        )
}
