@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersCloudwatchLogsParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logStreamName The name of the log stream.
 * @property timestamp The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. This is the JSON path to the field in the event e.g. $.detail.timestamp
 */
public data class PipeTargetParametersCloudwatchLogsParametersArgs(
    public val logStreamName: Output<String>? = null,
    public val timestamp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersCloudwatchLogsParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersCloudwatchLogsParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersCloudwatchLogsParametersArgs.builder()
            .logStreamName(logStreamName?.applyValue({ args0 -> args0 }))
            .timestamp(timestamp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersCloudwatchLogsParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersCloudwatchLogsParametersArgsBuilder internal constructor() {
    private var logStreamName: Output<String>? = null

    private var timestamp: Output<String>? = null

    /**
     * @param value The name of the log stream.
     */
    @JvmName("ueqhsoteywcrgcla")
    public suspend fun logStreamName(`value`: Output<String>) {
        this.logStreamName = value
    }

    /**
     * @param value The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. This is the JSON path to the field in the event e.g. $.detail.timestamp
     */
    @JvmName("rtkmdqqcafwmxqtu")
    public suspend fun timestamp(`value`: Output<String>) {
        this.timestamp = value
    }

    /**
     * @param value The name of the log stream.
     */
    @JvmName("pfxtrgeilxjkgrst")
    public suspend fun logStreamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreamName = mapped
    }

    /**
     * @param value The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. This is the JSON path to the field in the event e.g. $.detail.timestamp
     */
    @JvmName("jimriecaadrvvkxd")
    public suspend fun timestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestamp = mapped
    }

    internal fun build(): PipeTargetParametersCloudwatchLogsParametersArgs =
        PipeTargetParametersCloudwatchLogsParametersArgs(
            logStreamName = logStreamName,
            timestamp = timestamp,
        )
}
