@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property capacityProviderStrategies List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task. Valid values: true, false.
 * @property enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task. Valid values: true, false.
 * @property group Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
 * @property launchType Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The FARGATE value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. Valid Values: EC2, FARGATE, EXTERNAL
 * @property networkConfiguration Use this structure if the Amazon ECS task uses the awsvpc network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks. If you specify NetworkConfiguration when the target ECS task does not use the awsvpc network mode, the task fails. Detailed below.
 * @property overrides The overrides that are associated with a task. Detailed below.
 * @property placementConstraints An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
 * @property placementStrategies The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
 * @property platformVersion Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0. This structure is used only if LaunchType is FARGATE.
 * @property propagateTags Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action. Valid Values: TASK_DEFINITION
 * @property referenceId The reference ID to use for the task. Maximum length of 1,024.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taskCount The number of tasks to create based on TaskDefinition. The default is 1.
 * @property taskDefinitionArn The ARN of the task definition to use if the event target is an Amazon ECS task.
 */
public data class PipeTargetParametersEcsTaskParametersArgs(
    public val capacityProviderStrategies: Output<List<PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs>>? = null,
    public val enableEcsManagedTags: Output<Boolean>? = null,
    public val enableExecuteCommand: Output<Boolean>? = null,
    public val group: Output<String>? = null,
    public val launchType: Output<String>? = null,
    public val networkConfiguration: Output<PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs>? = null,
    public val overrides: Output<PipeTargetParametersEcsTaskParametersOverridesArgs>? = null,
    public val placementConstraints: Output<List<PipeTargetParametersEcsTaskParametersPlacementConstraintArgs>>? = null,
    public val placementStrategies: Output<List<PipeTargetParametersEcsTaskParametersPlacementStrategyArgs>>? = null,
    public val platformVersion: Output<String>? = null,
    public val propagateTags: Output<String>? = null,
    public val referenceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskCount: Output<Int>? = null,
    public val taskDefinitionArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersArgs.builder()
            .capacityProviderStrategies(
                capacityProviderStrategies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableEcsManagedTags(enableEcsManagedTags?.applyValue({ args0 -> args0 }))
            .enableExecuteCommand(enableExecuteCommand?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .launchType(launchType?.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .overrides(overrides?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .placementConstraints(
                placementConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .placementStrategies(
                placementStrategies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .platformVersion(platformVersion?.applyValue({ args0 -> args0 }))
            .propagateTags(propagateTags?.applyValue({ args0 -> args0 }))
            .referenceId(referenceId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskCount(taskCount?.applyValue({ args0 -> args0 }))
            .taskDefinitionArn(taskDefinitionArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersArgsBuilder internal constructor() {
    private var capacityProviderStrategies:
        Output<List<PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs>>? = null

    private var enableEcsManagedTags: Output<Boolean>? = null

    private var enableExecuteCommand: Output<Boolean>? = null

    private var group: Output<String>? = null

    private var launchType: Output<String>? = null

    private var networkConfiguration:
        Output<PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs>? = null

    private var overrides: Output<PipeTargetParametersEcsTaskParametersOverridesArgs>? = null

    private var placementConstraints:
        Output<List<PipeTargetParametersEcsTaskParametersPlacementConstraintArgs>>? = null

    private var placementStrategies:
        Output<List<PipeTargetParametersEcsTaskParametersPlacementStrategyArgs>>? = null

    private var platformVersion: Output<String>? = null

    private var propagateTags: Output<String>? = null

    private var referenceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskCount: Output<Int>? = null

    private var taskDefinitionArn: Output<String>? = null

    /**
     * @param value List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
     */
    @JvmName("amistyvppfdtsafq")
    public suspend fun capacityProviderStrategies(`value`: Output<List<PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = value
    }

    @JvmName("rhbnymtgjujxiojl")
    public suspend fun capacityProviderStrategies(vararg values: Output<PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs>) {
        this.capacityProviderStrategies = Output.all(values.asList())
    }

    /**
     * @param values List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
     */
    @JvmName("smdyfhtptlwbfeev")
    public suspend fun capacityProviderStrategies(values: List<Output<PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the task. Valid values: true, false.
     */
    @JvmName("eivovjlilrtqgtok")
    public suspend fun enableEcsManagedTags(`value`: Output<Boolean>) {
        this.enableEcsManagedTags = value
    }

    /**
     * @param value Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task. Valid values: true, false.
     */
    @JvmName("hdadaohjwfvcshdg")
    public suspend fun enableExecuteCommand(`value`: Output<Boolean>) {
        this.enableExecuteCommand = value
    }

    /**
     * @param value Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
     */
    @JvmName("kkwkxpxbjgcjrwof")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The FARGATE value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. Valid Values: EC2, FARGATE, EXTERNAL
     */
    @JvmName("webbnogedeachhkr")
    public suspend fun launchType(`value`: Output<String>) {
        this.launchType = value
    }

    /**
     * @param value Use this structure if the Amazon ECS task uses the awsvpc network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks. If you specify NetworkConfiguration when the target ECS task does not use the awsvpc network mode, the task fails. Detailed below.
     */
    @JvmName("slwtaaavcjtjgexa")
    public suspend fun networkConfiguration(`value`: Output<PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The overrides that are associated with a task. Detailed below.
     */
    @JvmName("reumuglhvdmvhjtb")
    public suspend fun overrides(`value`: Output<PipeTargetParametersEcsTaskParametersOverridesArgs>) {
        this.overrides = value
    }

    /**
     * @param value An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
     */
    @JvmName("qyhxqkdsdpujtbpr")
    public suspend fun placementConstraints(`value`: Output<List<PipeTargetParametersEcsTaskParametersPlacementConstraintArgs>>) {
        this.placementConstraints = value
    }

    @JvmName("vxfbwfuvmrlhjlwc")
    public suspend fun placementConstraints(vararg values: Output<PipeTargetParametersEcsTaskParametersPlacementConstraintArgs>) {
        this.placementConstraints = Output.all(values.asList())
    }

    /**
     * @param values An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
     */
    @JvmName("pameprmryqceyvvl")
    public suspend fun placementConstraints(values: List<Output<PipeTargetParametersEcsTaskParametersPlacementConstraintArgs>>) {
        this.placementConstraints = Output.all(values)
    }

    /**
     * @param value The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
     */
    @JvmName("odnmlbucvfkaokum")
    public suspend fun placementStrategies(`value`: Output<List<PipeTargetParametersEcsTaskParametersPlacementStrategyArgs>>) {
        this.placementStrategies = value
    }

    @JvmName("ttyoldtlylgvpcix")
    public suspend fun placementStrategies(vararg values: Output<PipeTargetParametersEcsTaskParametersPlacementStrategyArgs>) {
        this.placementStrategies = Output.all(values.asList())
    }

    /**
     * @param values The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
     */
    @JvmName("nimfaldsfdmvebsh")
    public suspend fun placementStrategies(values: List<Output<PipeTargetParametersEcsTaskParametersPlacementStrategyArgs>>) {
        this.placementStrategies = Output.all(values)
    }

    /**
     * @param value Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0. This structure is used only if LaunchType is FARGATE.
     */
    @JvmName("fraiadfenjqsmmwy")
    public suspend fun platformVersion(`value`: Output<String>) {
        this.platformVersion = value
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action. Valid Values: TASK_DEFINITION
     */
    @JvmName("gysyfncypwtlkvwa")
    public suspend fun propagateTags(`value`: Output<String>) {
        this.propagateTags = value
    }

    /**
     * @param value The reference ID to use for the task. Maximum length of 1,024.
     */
    @JvmName("htudvymkvypmwfee")
    public suspend fun referenceId(`value`: Output<String>) {
        this.referenceId = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wbdjkaldvscghmde")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of tasks to create based on TaskDefinition. The default is 1.
     */
    @JvmName("jqnsxwglhfkjqjvu")
    public suspend fun taskCount(`value`: Output<Int>) {
        this.taskCount = value
    }

    /**
     * @param value The ARN of the task definition to use if the event target is an Amazon ECS task.
     */
    @JvmName("cbnpyumjmfnxcowv")
    public suspend fun taskDefinitionArn(`value`: Output<String>) {
        this.taskDefinitionArn = value
    }

    /**
     * @param value List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
     */
    @JvmName("feaikjmahyssdhxa")
    public suspend fun capacityProviderStrategies(`value`: List<PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
     */
    @JvmName("nbqssmgcomfvfxiv")
    public suspend fun capacityProviderStrategies(argument: List<suspend PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
     */
    @JvmName("cvgkqnhglvphktjg")
    public suspend fun capacityProviderStrategies(vararg argument: suspend PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
     */
    @JvmName("aodghxdptlrdxwgs")
    public suspend fun capacityProviderStrategies(argument: suspend PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param values List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
     */
    @JvmName("bljjbuxqchlkhxkr")
    public suspend fun capacityProviderStrategies(vararg values: PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the task. Valid values: true, false.
     */
    @JvmName("awklgdlvmpnfimas")
    public suspend fun enableEcsManagedTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEcsManagedTags = mapped
    }

    /**
     * @param value Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task. Valid values: true, false.
     */
    @JvmName("ytirekyqtvxbpocr")
    public suspend fun enableExecuteCommand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExecuteCommand = mapped
    }

    /**
     * @param value Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
     */
    @JvmName("dnvbpuxfuuecrumo")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The FARGATE value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. Valid Values: EC2, FARGATE, EXTERNAL
     */
    @JvmName("sfeqelbkfowmijex")
    public suspend fun launchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchType = mapped
    }

    /**
     * @param value Use this structure if the Amazon ECS task uses the awsvpc network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks. If you specify NetworkConfiguration when the target ECS task does not use the awsvpc network mode, the task fails. Detailed below.
     */
    @JvmName("gfrrdthfitkfikjg")
    public suspend fun networkConfiguration(`value`: PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Use this structure if the Amazon ECS task uses the awsvpc network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks. If you specify NetworkConfiguration when the target ECS task does not use the awsvpc network mode, the task fails. Detailed below.
     */
    @JvmName("qtaorowsnyjhffrp")
    public suspend fun networkConfiguration(argument: suspend PipeTargetParametersEcsTaskParametersNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeTargetParametersEcsTaskParametersNetworkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The overrides that are associated with a task. Detailed below.
     */
    @JvmName("kyftumnicaguumra")
    public suspend fun overrides(`value`: PipeTargetParametersEcsTaskParametersOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param argument The overrides that are associated with a task. Detailed below.
     */
    @JvmName("etvkqxuxjevstwwv")
    public suspend fun overrides(argument: suspend PipeTargetParametersEcsTaskParametersOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersEcsTaskParametersOverridesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param value An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
     */
    @JvmName("remwpetdcbbribkq")
    public suspend fun placementConstraints(`value`: List<PipeTargetParametersEcsTaskParametersPlacementConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
     */
    @JvmName("jdujdtpcmyirkpej")
    public suspend fun placementConstraints(argument: List<suspend PipeTargetParametersEcsTaskParametersPlacementConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersPlacementConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
     */
    @JvmName("uneogjqpspyvrokq")
    public suspend fun placementConstraints(vararg argument: suspend PipeTargetParametersEcsTaskParametersPlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersPlacementConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
     */
    @JvmName("irthshplgrgbquqs")
    public suspend fun placementConstraints(argument: suspend PipeTargetParametersEcsTaskParametersPlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersPlacementConstraintArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param values An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
     */
    @JvmName("ohvmrxpfknvbtalk")
    public suspend fun placementConstraints(vararg values: PipeTargetParametersEcsTaskParametersPlacementConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
     */
    @JvmName("ltpnmccpprnnempt")
    public suspend fun placementStrategies(`value`: List<PipeTargetParametersEcsTaskParametersPlacementStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementStrategies = mapped
    }

    /**
     * @param argument The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
     */
    @JvmName("vynifusaoopobrqd")
    public suspend fun placementStrategies(argument: List<suspend PipeTargetParametersEcsTaskParametersPlacementStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersPlacementStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementStrategies = mapped
    }

    /**
     * @param argument The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
     */
    @JvmName("lpreislhctnhcbnd")
    public suspend fun placementStrategies(vararg argument: suspend PipeTargetParametersEcsTaskParametersPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersPlacementStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementStrategies = mapped
    }

    /**
     * @param argument The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
     */
    @JvmName("wddstwyxjqfyicxe")
    public suspend fun placementStrategies(argument: suspend PipeTargetParametersEcsTaskParametersPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersPlacementStrategyArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.placementStrategies = mapped
    }

    /**
     * @param values The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
     */
    @JvmName("xcvtyxxpffnpmqaj")
    public suspend fun placementStrategies(vararg values: PipeTargetParametersEcsTaskParametersPlacementStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementStrategies = mapped
    }

    /**
     * @param value Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0. This structure is used only if LaunchType is FARGATE.
     */
    @JvmName("dnrgnnqbupnekgul")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformVersion = mapped
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action. Valid Values: TASK_DEFINITION
     */
    @JvmName("kgvgkyflsxmevrls")
    public suspend fun propagateTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagateTags = mapped
    }

    /**
     * @param value The reference ID to use for the task. Maximum length of 1,024.
     */
    @JvmName("nfqyucslliigkqlp")
    public suspend fun referenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceId = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lspgksvhdgnpmxju")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("flfackcuvkourqyk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The number of tasks to create based on TaskDefinition. The default is 1.
     */
    @JvmName("lhftrruesellnajh")
    public suspend fun taskCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskCount = mapped
    }

    /**
     * @param value The ARN of the task definition to use if the event target is an Amazon ECS task.
     */
    @JvmName("ngilavlegtacyfdo")
    public suspend fun taskDefinitionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskDefinitionArn = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersArgs =
        PipeTargetParametersEcsTaskParametersArgs(
            capacityProviderStrategies = capacityProviderStrategies,
            enableEcsManagedTags = enableEcsManagedTags,
            enableExecuteCommand = enableExecuteCommand,
            group = group,
            launchType = launchType,
            networkConfiguration = networkConfiguration,
            overrides = overrides,
            placementConstraints = placementConstraints,
            placementStrategies = placementStrategies,
            platformVersion = platformVersion,
            propagateTags = propagateTags,
            referenceId = referenceId,
            tags = tags,
            taskCount = taskCount,
            taskDefinitionArn = taskDefinitionArn ?: throw PulumiNullFieldException("taskDefinitionArn"),
        )
}
