@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property base The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. Maximum value of 100,000.
 * @property capacityProvider The short name of the capacity provider. Maximum value of 255.
 * @property weight The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Maximum value of 1,000.
 */
public data class PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs(
    public val base: Output<Int>? = null,
    public val capacityProvider: Output<String>,
    public val weight: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs.builder()
            .base(base?.applyValue({ args0 -> args0 }))
            .capacityProvider(capacityProvider.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgsBuilder internal constructor() {
    private var base: Output<Int>? = null

    private var capacityProvider: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. Maximum value of 100,000.
     */
    @JvmName("seoqryixhivsbjlv")
    public suspend fun base(`value`: Output<Int>) {
        this.base = value
    }

    /**
     * @param value The short name of the capacity provider. Maximum value of 255.
     */
    @JvmName("tjxcmgepksbvocbg")
    public suspend fun capacityProvider(`value`: Output<String>) {
        this.capacityProvider = value
    }

    /**
     * @param value The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Maximum value of 1,000.
     */
    @JvmName("dwtmekslylwohusg")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. Maximum value of 100,000.
     */
    @JvmName("rfngrfpwvltgfsmw")
    public suspend fun base(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base = mapped
    }

    /**
     * @param value The short name of the capacity provider. Maximum value of 255.
     */
    @JvmName("hycmpfakoqdxtjmu")
    public suspend fun capacityProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProvider = mapped
    }

    /**
     * @param value The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Maximum value of 1,000.
     */
    @JvmName("jipscimhjisxnpup")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs =
        PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs(
            base = base,
            capacityProvider = capacityProvider ?: throw PulumiNullFieldException("capacityProvider"),
            weight = weight,
        )
}
