@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containerOverrides One or more container overrides that are sent to a task. Detailed below.
 * @property cpu The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property ephemeralStorage The ephemeral storage setting override for the task.  Detailed below.
 * @property executionRoleArn The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
 * @property inferenceAcceleratorOverrides List of Elastic Inference accelerator overrides for the task. Detailed below.
 * @property memory The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
 * @property taskRoleArn The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role.
 */
public data class PipeTargetParametersEcsTaskParametersOverridesArgs(
    public val containerOverrides: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs>>? = null,
    public val cpu: Output<String>? = null,
    public val ephemeralStorage: Output<PipeTargetParametersEcsTaskParametersOverridesEphemeralStorageArgs>? = null,
    public val executionRoleArn: Output<String>? = null,
    public val inferenceAcceleratorOverrides: Output<List<PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs>>? =
        null,
    public val memory: Output<String>? = null,
    public val taskRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesArgs.builder()
            .containerOverrides(
                containerOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .ephemeralStorage(ephemeralStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .executionRoleArn(executionRoleArn?.applyValue({ args0 -> args0 }))
            .inferenceAcceleratorOverrides(
                inferenceAcceleratorOverrides?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .memory(memory?.applyValue({ args0 -> args0 }))
            .taskRoleArn(taskRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersOverridesArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersOverridesArgsBuilder internal constructor() {
    private var containerOverrides:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs>>? = null

    private var cpu: Output<String>? = null

    private var ephemeralStorage:
        Output<PipeTargetParametersEcsTaskParametersOverridesEphemeralStorageArgs>? = null

    private var executionRoleArn: Output<String>? = null

    private var inferenceAcceleratorOverrides:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs>>? =
        null

    private var memory: Output<String>? = null

    private var taskRoleArn: Output<String>? = null

    /**
     * @param value One or more container overrides that are sent to a task. Detailed below.
     */
    @JvmName("bbvnkehdugneksnh")
    public suspend fun containerOverrides(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs>>) {
        this.containerOverrides = value
    }

    @JvmName("jvefyofbnedhawfm")
    public suspend fun containerOverrides(vararg values: Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs>) {
        this.containerOverrides = Output.all(values.asList())
    }

    /**
     * @param values One or more container overrides that are sent to a task. Detailed below.
     */
    @JvmName("sblffroydxegsewq")
    public suspend fun containerOverrides(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs>>) {
        this.containerOverrides = Output.all(values)
    }

    /**
     * @param value The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("hdagebjtukwwpkyq")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value The ephemeral storage setting override for the task.  Detailed below.
     */
    @JvmName("hkgmhweehcjjjbos")
    public suspend fun ephemeralStorage(`value`: Output<PipeTargetParametersEcsTaskParametersOverridesEphemeralStorageArgs>) {
        this.ephemeralStorage = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
     */
    @JvmName("narinprkqekjfdun")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value List of Elastic Inference accelerator overrides for the task. Detailed below.
     */
    @JvmName("xcaufrssqtrdnlav")
    public suspend fun inferenceAcceleratorOverrides(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs>>) {
        this.inferenceAcceleratorOverrides = value
    }

    @JvmName("ajoxnvsubujisngn")
    public suspend fun inferenceAcceleratorOverrides(vararg values: Output<PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs>) {
        this.inferenceAcceleratorOverrides = Output.all(values.asList())
    }

    /**
     * @param values List of Elastic Inference accelerator overrides for the task. Detailed below.
     */
    @JvmName("kifairleqvlkgqyb")
    public suspend fun inferenceAcceleratorOverrides(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs>>) {
        this.inferenceAcceleratorOverrides = Output.all(values)
    }

    /**
     * @param value The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
     */
    @JvmName("lgndgblwqjcxkxba")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role.
     */
    @JvmName("wqrtuovmdaqmmtqw")
    public suspend fun taskRoleArn(`value`: Output<String>) {
        this.taskRoleArn = value
    }

    /**
     * @param value One or more container overrides that are sent to a task. Detailed below.
     */
    @JvmName("ucexlgogtultwplw")
    public suspend fun containerOverrides(`value`: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerOverrides = mapped
    }

    /**
     * @param argument One or more container overrides that are sent to a task. Detailed below.
     */
    @JvmName("jqmwabrbkaxhfsfx")
    public suspend fun containerOverrides(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containerOverrides = mapped
    }

    /**
     * @param argument One or more container overrides that are sent to a task. Detailed below.
     */
    @JvmName("gsddlfphaackpwyt")
    public suspend fun containerOverrides(vararg argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containerOverrides = mapped
    }

    /**
     * @param argument One or more container overrides that are sent to a task. Detailed below.
     */
    @JvmName("donqbbippxghunpa")
    public suspend fun containerOverrides(argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.containerOverrides = mapped
    }

    /**
     * @param values One or more container overrides that are sent to a task. Detailed below.
     */
    @JvmName("lgrbxvtsttibdbkk")
    public suspend fun containerOverrides(vararg values: PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerOverrides = mapped
    }

    /**
     * @param value The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("aeknmbmqrxqsnkjd")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The ephemeral storage setting override for the task.  Detailed below.
     */
    @JvmName("hgslbunrmthpiuyu")
    public suspend fun ephemeralStorage(`value`: PipeTargetParametersEcsTaskParametersOverridesEphemeralStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralStorage = mapped
    }

    /**
     * @param argument The ephemeral storage setting override for the task.  Detailed below.
     */
    @JvmName("oacwtvimxavpakuo")
    public suspend fun ephemeralStorage(argument: suspend PipeTargetParametersEcsTaskParametersOverridesEphemeralStorageArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeTargetParametersEcsTaskParametersOverridesEphemeralStorageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ephemeralStorage = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
     */
    @JvmName("hxnvrwsbvvxwkwdt")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value List of Elastic Inference accelerator overrides for the task. Detailed below.
     */
    @JvmName("wtaqexnwrisjnbak")
    public suspend fun inferenceAcceleratorOverrides(`value`: List<PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param argument List of Elastic Inference accelerator overrides for the task. Detailed below.
     */
    @JvmName("ouhomghvxhvdavcp")
    public suspend fun inferenceAcceleratorOverrides(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param argument List of Elastic Inference accelerator overrides for the task. Detailed below.
     */
    @JvmName("bnxlnoytlalejtdw")
    public suspend fun inferenceAcceleratorOverrides(vararg argument: suspend PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param argument List of Elastic Inference accelerator overrides for the task. Detailed below.
     */
    @JvmName("sfypassqijfmwtoc")
    public suspend fun inferenceAcceleratorOverrides(argument: suspend PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param values List of Elastic Inference accelerator overrides for the task. Detailed below.
     */
    @JvmName("kujvehrbxdcpnavv")
    public suspend fun inferenceAcceleratorOverrides(vararg values: PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inferenceAcceleratorOverrides = mapped
    }

    /**
     * @param value The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
     */
    @JvmName("bcnbadgfocllenvs")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role.
     */
    @JvmName("decgevbxervmiois")
    public suspend fun taskRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskRoleArn = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersOverridesArgs =
        PipeTargetParametersEcsTaskParametersOverridesArgs(
            containerOverrides = containerOverrides,
            cpu = cpu,
            ephemeralStorage = ephemeralStorage,
            executionRoleArn = executionRoleArn,
            inferenceAcceleratorOverrides = inferenceAcceleratorOverrides,
            memory = memory,
            taskRoleArn = taskRoleArn,
        )
}
