@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property commands List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
 * @property cpu The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property environmentFiles A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
 * @property environments The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
 * @property memory The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
 * @property memoryReservation The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property name Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
 */
public data class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs(
    public val commands: Output<List<String>>? = null,
    public val cpu: Output<Int>? = null,
    public val environmentFiles: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>? =
        null,
    public val environments: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>? =
        null,
    public val memory: Output<Int>? = null,
    public val memoryReservation: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val resourceRequirements: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs.builder()
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .environmentFiles(
                environmentFiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .environments(
                environments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .memory(memory?.applyValue({ args0 -> args0 }))
            .memoryReservation(memoryReservation?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceRequirements(
                resourceRequirements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder internal constructor() {
    private var commands: Output<List<String>>? = null

    private var cpu: Output<Int>? = null

    private var environmentFiles:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>? =
        null

    private var environments:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>? =
        null

    private var memory: Output<Int>? = null

    private var memoryReservation: Output<Int>? = null

    private var name: Output<String>? = null

    private var resourceRequirements:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>? =
        null

    /**
     * @param value List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("alwtbrbiaxdtksbe")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("qcwbmxfnuebqqtta")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("xmdohbikgnvantuj")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("wptminqlndrmpypw")
    public suspend fun cpu(`value`: Output<Int>) {
        this.cpu = value
    }

    /**
     * @param value A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("sxsvlnblewvyxpgv")
    public suspend fun environmentFiles(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>) {
        this.environmentFiles = value
    }

    @JvmName("hnfhjhnlxrrnkbjb")
    public suspend fun environmentFiles(vararg values: Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>) {
        this.environmentFiles = Output.all(values.asList())
    }

    /**
     * @param values A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("ckmmapfeuwdadgqn")
    public suspend fun environmentFiles(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>) {
        this.environmentFiles = Output.all(values)
    }

    /**
     * @param value The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("ibdeywsskgujpwgu")
    public suspend fun environments(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>) {
        this.environments = value
    }

    @JvmName("hbwkirdtskcubqec")
    public suspend fun environments(vararg values: Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>) {
        this.environments = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("fgyfcymixdreujvy")
    public suspend fun environments(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>) {
        this.environments = Output.all(values)
    }

    /**
     * @param value The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
     */
    @JvmName("lsrttnhnbmpnmrfq")
    public suspend fun memory(`value`: Output<Int>) {
        this.memory = value
    }

    /**
     * @param value The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("lctwwqdbfhlodcja")
    public suspend fun memoryReservation(`value`: Output<Int>) {
        this.memoryReservation = value
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("cfeheycdhyrknerl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("eoriehwovwxuwwai")
    public suspend fun resourceRequirements(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>) {
        this.resourceRequirements = value
    }

    @JvmName("docgtlntebyaueeo")
    public suspend fun resourceRequirements(vararg values: Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>) {
        this.resourceRequirements = Output.all(values.asList())
    }

    /**
     * @param values The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("vymfeqmtlbmthocq")
    public suspend fun resourceRequirements(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>) {
        this.resourceRequirements = Output.all(values)
    }

    /**
     * @param value List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("tflctpwuhuqoitrw")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("pmetlckdxjsxvdgm")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("ekupuhcrvsqaiosg")
    public suspend fun cpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("gekjuiucmddsabot")
    public suspend fun environmentFiles(`value`: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentFiles = mapped
    }

    /**
     * @param argument A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("emtyisyyomrqwtid")
    public suspend fun environmentFiles(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentFiles = mapped
    }

    /**
     * @param argument A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("fxhgiwblrrxkpsgv")
    public suspend fun environmentFiles(vararg argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentFiles = mapped
    }

    /**
     * @param argument A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("xtpynmnmubdlxbbm")
    public suspend fun environmentFiles(argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.environmentFiles = mapped
    }

    /**
     * @param values A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("ccgqnlylvuiwcaun")
    public suspend fun environmentFiles(vararg values: PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentFiles = mapped
    }

    /**
     * @param value The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("ejhepfpecwvvxinq")
    public suspend fun environments(`value`: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("rwbynmonwqxcggfg")
    public suspend fun environments(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("hpqtwahpefvaubuk")
    public suspend fun environments(vararg argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("bmseqkwcgwnadmaj")
    public suspend fun environments(argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param values The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("rjwpqotucufypvtc")
    public suspend fun environments(vararg values: PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param value The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
     */
    @JvmName("wgwoorxpsvduwdlh")
    public suspend fun memory(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("jhvstqqtwqsqwwhw")
    public suspend fun memoryReservation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryReservation = mapped
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("hkorairshnvmhrny")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("teajhfdrrcxugwfl")
    public suspend fun resourceRequirements(`value`: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("pktvgoqlnjtluqxb")
    public suspend fun resourceRequirements(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("ryypusrykwoodlfr")
    public suspend fun resourceRequirements(vararg argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("morpscbmbkptxkip")
    public suspend fun resourceRequirements(argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param values The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("ratjeubimqrjesmf")
    public suspend fun resourceRequirements(vararg values: PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceRequirements = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs =
        PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs(
            commands = commands,
            cpu = cpu,
            environmentFiles = environmentFiles,
            environments = environments,
            memory = memory,
            memoryReservation = memoryReservation,
            name = name,
            resourceRequirements = resourceRequirements,
        )
}
