@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
 */
public data class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("tbxunrwtlcbxofki")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
     */
    @JvmName("ngfoauksecdfdwrm")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("emdeyeecjsbrtrto")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
     */
    @JvmName("hfxbvevjukaovjhf")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs =
        PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs(
            name = name,
            `value` = `value`,
        )
}
