@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
 * @property deviceType The Elastic Inference accelerator type to use.
 */
public data class PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs(
    public val deviceName: Output<String>? = null,
    public val deviceType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .deviceType(deviceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgsBuilder
internal constructor() {
    private var deviceName: Output<String>? = null

    private var deviceType: Output<String>? = null

    /**
     * @param value The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
     */
    @JvmName("fnxhnxexgjuoakem")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The Elastic Inference accelerator type to use.
     */
    @JvmName("eouwpdoxvlrpahyg")
    public suspend fun deviceType(`value`: Output<String>) {
        this.deviceType = value
    }

    /**
     * @param value The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
     */
    @JvmName("bpiefurxbxassumi")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The Elastic Inference accelerator type to use.
     */
    @JvmName("katjxrqpbvushdbu")
    public suspend fun deviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceType = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs =
        PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs(
            deviceName = deviceName,
            deviceType = deviceType,
        )
}
