@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property field The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used. Maximum length of 255.
 * @property type The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
 */
public data class PipeTargetParametersEcsTaskParametersPlacementStrategyArgs(
    public val `field`: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementStrategyArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementStrategyArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementStrategyArgs.builder()
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersPlacementStrategyArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersPlacementStrategyArgsBuilder internal constructor() {
    private var `field`: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used. Maximum length of 255.
     */
    @JvmName("ohuwtssvkmhkrdaw")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("ywmihvcsxbnoiuut")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used. Maximum length of 255.
     */
    @JvmName("ostiwjgyavkjqroq")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("bqqgegqbetxhavgk")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersPlacementStrategyArgs =
        PipeTargetParametersEcsTaskParametersPlacementStrategyArgs(
            `field` = `field`,
            type = type,
        )
}
