@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property headerParameters
 * @property pathParameterValues
 * @property queryStringParameters
 */
public data class PipeTargetParametersHttpParametersArgs(
    public val headerParameters: Output<Map<String, String>>? = null,
    public val pathParameterValues: Output<String>? = null,
    public val queryStringParameters: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs.builder()
            .headerParameters(
                headerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .pathParameterValues(pathParameterValues?.applyValue({ args0 -> args0 }))
            .queryStringParameters(
                queryStringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersHttpParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersHttpParametersArgsBuilder internal constructor() {
    private var headerParameters: Output<Map<String, String>>? = null

    private var pathParameterValues: Output<String>? = null

    private var queryStringParameters: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("dimscrghmyutsual")
    public suspend fun headerParameters(`value`: Output<Map<String, String>>) {
        this.headerParameters = value
    }

    /**
     * @param value
     */
    @JvmName("auldvwkcywrbrape")
    public suspend fun pathParameterValues(`value`: Output<String>) {
        this.pathParameterValues = value
    }

    /**
     * @param value
     */
    @JvmName("rbxmgeyrteljpypf")
    public suspend fun queryStringParameters(`value`: Output<Map<String, String>>) {
        this.queryStringParameters = value
    }

    /**
     * @param value
     */
    @JvmName("ucaxrpnnpnevdcrm")
    public suspend fun headerParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param values
     */
    @JvmName("xyoxkiwsufswrudt")
    public fun headerParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param value
     */
    @JvmName("wpudjxwrvmfddiao")
    public suspend fun pathParameterValues(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathParameterValues = mapped
    }

    /**
     * @param value
     */
    @JvmName("ghprwrexxbofhcdn")
    public suspend fun queryStringParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    /**
     * @param values
     */
    @JvmName("aatsycdaocodsoso")
    public fun queryStringParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    internal fun build(): PipeTargetParametersHttpParametersArgs =
        PipeTargetParametersHttpParametersArgs(
            headerParameters = headerParameters,
            pathParameterValues = pathParameterValues,
            queryStringParameters = queryStringParameters,
        )
}
