@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersKinesisStreamParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partitionKey Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
 */
public data class PipeTargetParametersKinesisStreamParametersArgs(
    public val partitionKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersKinesisStreamParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersKinesisStreamParametersArgs = com.pulumi.aws.pipes.inputs.PipeTargetParametersKinesisStreamParametersArgs.builder()
        .partitionKey(partitionKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersKinesisStreamParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersKinesisStreamParametersArgsBuilder internal constructor() {
    private var partitionKey: Output<String>? = null

    /**
     * @param value Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
     */
    @JvmName("uiaceduvnecrwquw")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
     */
    @JvmName("cvmbssgupdcxwqhx")
    public suspend fun partitionKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    internal fun build(): PipeTargetParametersKinesisStreamParametersArgs =
        PipeTargetParametersKinesisStreamParametersArgs(
            partitionKey = partitionKey ?: throw PulumiNullFieldException("partitionKey"),
        )
}
