@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersLambdaFunctionParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property invocationType Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
 */
public data class PipeTargetParametersLambdaFunctionParametersArgs(
    public val invocationType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersLambdaFunctionParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersLambdaFunctionParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersLambdaFunctionParametersArgs.builder()
            .invocationType(invocationType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersLambdaFunctionParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersLambdaFunctionParametersArgsBuilder internal constructor() {
    private var invocationType: Output<String>? = null

    /**
     * @param value Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
     */
    @JvmName("uwpujvlbexbkqjvi")
    public suspend fun invocationType(`value`: Output<String>) {
        this.invocationType = value
    }

    /**
     * @param value Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
     */
    @JvmName("ssymeannbjqtffnn")
    public suspend fun invocationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.invocationType = mapped
    }

    internal fun build(): PipeTargetParametersLambdaFunctionParametersArgs =
        PipeTargetParametersLambdaFunctionParametersArgs(
            invocationType = invocationType ?: throw PulumiNullFieldException("invocationType"),
        )
}
