@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property pipelineParameters List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
 */
public data class PipeTargetParametersSagemakerPipelineParametersArgs(
    public val pipelineParameters: Output<List<PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersArgs.builder()
            .pipelineParameters(
                pipelineParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersSagemakerPipelineParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersSagemakerPipelineParametersArgsBuilder internal constructor() {
    private var pipelineParameters:
        Output<List<PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs>>? = null

    /**
     * @param value List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
     */
    @JvmName("cntstjoyaulfsrxu")
    public suspend fun pipelineParameters(`value`: Output<List<PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs>>) {
        this.pipelineParameters = value
    }

    @JvmName("otbqgtgkqnhutmra")
    public suspend fun pipelineParameters(vararg values: Output<PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs>) {
        this.pipelineParameters = Output.all(values.asList())
    }

    /**
     * @param values List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
     */
    @JvmName("jqjlrdbhehcpqkyo")
    public suspend fun pipelineParameters(values: List<Output<PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs>>) {
        this.pipelineParameters = Output.all(values)
    }

    /**
     * @param value List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
     */
    @JvmName("tdlauiaiqacdhcou")
    public suspend fun pipelineParameters(`value`: List<PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineParameters = mapped
    }

    /**
     * @param argument List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
     */
    @JvmName("hjptrndooserpoye")
    public suspend fun pipelineParameters(argument: List<suspend PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineParameters = mapped
    }

    /**
     * @param argument List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
     */
    @JvmName("wjlenmghlujrhqbk")
    public suspend fun pipelineParameters(vararg argument: suspend PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineParameters = mapped
    }

    /**
     * @param argument List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
     */
    @JvmName("bhtldfocsvfscfth")
    public suspend fun pipelineParameters(argument: suspend PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.pipelineParameters = mapped
    }

    /**
     * @param values List of Parameter names and values for SageMaker Model Building Pipeline execution. Detailed below.
     */
    @JvmName("ttgkmagqmbgxacfk")
    public suspend fun pipelineParameters(vararg values: PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelineParameters = mapped
    }

    internal fun build(): PipeTargetParametersSagemakerPipelineParametersArgs =
        PipeTargetParametersSagemakerPipelineParametersArgs(
            pipelineParameters = pipelineParameters,
        )
}
