@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
 */
public data class PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("nxrthuivfewdykxf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
     */
    @JvmName("bdyplwqdawgjjekc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("hvwcrbakvoohreyv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
     */
    @JvmName("bnnmtefdyabmvvlg")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs =
        PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
