@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property headerParameters
 * @property pathParameterValues
 * @property queryStringParameters
 */
public data class PipeEnrichmentParametersHttpParameters(
    public val headerParameters: Map<String, String>? = null,
    public val pathParameterValues: String? = null,
    public val queryStringParameters: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeEnrichmentParametersHttpParameters): PipeEnrichmentParametersHttpParameters = PipeEnrichmentParametersHttpParameters(
            headerParameters = javaType.headerParameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            pathParameterValues = javaType.pathParameterValues().map({ args0 -> args0 }).orElse(null),
            queryStringParameters = javaType.queryStringParameters().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
        )
    }
}
