@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cloudwatchLogsLogDestination Amazon CloudWatch Logs logging configuration settings for the pipe. Detailed below.
 * @property firehoseLogDestination Amazon Kinesis Data Firehose logging configuration settings for the pipe. Detailed below.
 * @property includeExecutionDatas String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
 * @property level The level of logging detail to include. Valid values `OFF`, `ERROR`, `INFO` and `TRACE`.
 * @property s3LogDestination Amazon S3 logging configuration settings for the pipe. Detailed below.
 */
public data class PipeLogConfiguration(
    public val cloudwatchLogsLogDestination: PipeLogConfigurationCloudwatchLogsLogDestination? = null,
    public val firehoseLogDestination: PipeLogConfigurationFirehoseLogDestination? = null,
    public val includeExecutionDatas: List<String>? = null,
    public val level: String,
    public val s3LogDestination: PipeLogConfigurationS3LogDestination? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeLogConfiguration): PipeLogConfiguration = PipeLogConfiguration(
            cloudwatchLogsLogDestination = javaType.cloudwatchLogsLogDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeLogConfigurationCloudwatchLogsLogDestination.Companion.toKotlin(args0)
                })
            }).orElse(null),
            firehoseLogDestination = javaType.firehoseLogDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeLogConfigurationFirehoseLogDestination.Companion.toKotlin(args0)
                })
            }).orElse(null),
            includeExecutionDatas = javaType.includeExecutionDatas().map({ args0 -> args0 }),
            level = javaType.level(),
            s3LogDestination = javaType.s3LogDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeLogConfigurationS3LogDestination.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
