@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
 * @property bucketOwner Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
 * @property outputFormat EventBridge format for the log records. Valid values `json`, `plain` and `w3c`.
 * @property prefix Prefix text with which to begin Amazon S3 log object names.
 */
public data class PipeLogConfigurationS3LogDestination(
    public val bucketName: String,
    public val bucketOwner: String,
    public val outputFormat: String? = null,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeLogConfigurationS3LogDestination): PipeLogConfigurationS3LogDestination = PipeLogConfigurationS3LogDestination(
            bucketName = javaType.bucketName(),
            bucketOwner = javaType.bucketOwner(),
            outputFormat = javaType.outputFormat().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
