@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property activemqBrokerParameters The parameters for using an Active MQ broker as a source. Detailed below.
 * @property dynamodbStreamParameters The parameters for using a DynamoDB stream as a source.  Detailed below.
 * @property filterCriteria The collection of event patterns used to [filter events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-filtering.html). Detailed below.
 * @property kinesisStreamParameters The parameters for using a Kinesis stream as a source. Detailed below.
 * @property managedStreamingKafkaParameters The parameters for using an MSK stream as a source. Detailed below.
 * @property rabbitmqBrokerParameters The parameters for using a Rabbit MQ broker as a source. Detailed below.
 * @property selfManagedKafkaParameters The parameters for using a self-managed Apache Kafka stream as a source. Detailed below.
 * @property sqsQueueParameters The parameters for using a Amazon SQS stream as a source. Detailed below.
 */
public data class PipeSourceParameters(
    public val activemqBrokerParameters: PipeSourceParametersActivemqBrokerParameters? = null,
    public val dynamodbStreamParameters: PipeSourceParametersDynamodbStreamParameters? = null,
    public val filterCriteria: PipeSourceParametersFilterCriteria? = null,
    public val kinesisStreamParameters: PipeSourceParametersKinesisStreamParameters? = null,
    public val managedStreamingKafkaParameters: PipeSourceParametersManagedStreamingKafkaParameters? =
        null,
    public val rabbitmqBrokerParameters: PipeSourceParametersRabbitmqBrokerParameters? = null,
    public val selfManagedKafkaParameters: PipeSourceParametersSelfManagedKafkaParameters? = null,
    public val sqsQueueParameters: PipeSourceParametersSqsQueueParameters? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParameters): PipeSourceParameters = PipeSourceParameters(
            activemqBrokerParameters = javaType.activemqBrokerParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersActivemqBrokerParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dynamodbStreamParameters = javaType.dynamodbStreamParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersDynamodbStreamParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filterCriteria = javaType.filterCriteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersFilterCriteria.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kinesisStreamParameters = javaType.kinesisStreamParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersKinesisStreamParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedStreamingKafkaParameters = javaType.managedStreamingKafkaParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersManagedStreamingKafkaParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rabbitmqBrokerParameters = javaType.rabbitmqBrokerParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersRabbitmqBrokerParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            selfManagedKafkaParameters = javaType.selfManagedKafkaParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersSelfManagedKafkaParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqsQueueParameters = javaType.sqsQueueParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersSqsQueueParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
