@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property deadLetterConfig Define the target queue to send dead-letter queue events to. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property maximumRecordAgeInSeconds Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
 * @property maximumRetryAttempts Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
 * @property onPartialBatchItemFailure Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
 * @property parallelizationFactor The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
 * @property startingPosition The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
 */
public data class PipeSourceParametersDynamodbStreamParameters(
    public val batchSize: Int? = null,
    public val deadLetterConfig: PipeSourceParametersDynamodbStreamParametersDeadLetterConfig? = null,
    public val maximumBatchingWindowInSeconds: Int? = null,
    public val maximumRecordAgeInSeconds: Int? = null,
    public val maximumRetryAttempts: Int? = null,
    public val onPartialBatchItemFailure: String? = null,
    public val parallelizationFactor: Int? = null,
    public val startingPosition: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParametersDynamodbStreamParameters): PipeSourceParametersDynamodbStreamParameters = PipeSourceParametersDynamodbStreamParameters(
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            deadLetterConfig = javaType.deadLetterConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersDynamodbStreamParametersDeadLetterConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maximumBatchingWindowInSeconds = javaType.maximumBatchingWindowInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            maximumRecordAgeInSeconds = javaType.maximumRecordAgeInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            maximumRetryAttempts = javaType.maximumRetryAttempts().map({ args0 -> args0 }).orElse(null),
            onPartialBatchItemFailure = javaType.onPartialBatchItemFailure().map({ args0 ->
                args0
            }).orElse(null),
            parallelizationFactor = javaType.parallelizationFactor().map({ args0 -> args0 }).orElse(null),
            startingPosition = javaType.startingPosition(),
        )
    }
}
