@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 */
public data class PipeSourceParametersSqsQueueParameters(
    public val batchSize: Int? = null,
    public val maximumBatchingWindowInSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParametersSqsQueueParameters): PipeSourceParametersSqsQueueParameters = PipeSourceParametersSqsQueueParameters(
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            maximumBatchingWindowInSeconds = javaType.maximumBatchingWindowInSeconds().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
