@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchJobParameters The parameters for using an AWS Batch job as a target. Detailed below.
 * @property cloudwatchLogsParameters The parameters for using an CloudWatch Logs log stream as a target. Detailed below.
 * @property ecsTaskParameters The parameters for using an Amazon ECS task as a target. Detailed below.
 * @property eventbridgeEventBusParameters The parameters for using an EventBridge event bus as a target. Detailed below.
 * @property httpParameters These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. Detailed below.
 * @property inputTemplate Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
 * @property kinesisStreamParameters The parameters for using a Kinesis stream as a source. Detailed below.
 * @property lambdaFunctionParameters The parameters for using a Lambda function as a target. Detailed below.
 * @property redshiftDataParameters These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement. Detailed below.
 * @property sagemakerPipelineParameters The parameters for using a SageMaker pipeline as a target. Detailed below.
 * @property sqsQueueParameters The parameters for using a Amazon SQS stream as a target. Detailed below.
 * @property stepFunctionStateMachineParameters The parameters for using a Step Functions state machine as a target. Detailed below.
 */
public data class PipeTargetParameters(
    public val batchJobParameters: PipeTargetParametersBatchJobParameters? = null,
    public val cloudwatchLogsParameters: PipeTargetParametersCloudwatchLogsParameters? = null,
    public val ecsTaskParameters: PipeTargetParametersEcsTaskParameters? = null,
    public val eventbridgeEventBusParameters: PipeTargetParametersEventbridgeEventBusParameters? =
        null,
    public val httpParameters: PipeTargetParametersHttpParameters? = null,
    public val inputTemplate: String? = null,
    public val kinesisStreamParameters: PipeTargetParametersKinesisStreamParameters? = null,
    public val lambdaFunctionParameters: PipeTargetParametersLambdaFunctionParameters? = null,
    public val redshiftDataParameters: PipeTargetParametersRedshiftDataParameters? = null,
    public val sagemakerPipelineParameters: PipeTargetParametersSagemakerPipelineParameters? = null,
    public val sqsQueueParameters: PipeTargetParametersSqsQueueParameters? = null,
    public val stepFunctionStateMachineParameters: PipeTargetParametersStepFunctionStateMachineParameters? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParameters): PipeTargetParameters = PipeTargetParameters(
            batchJobParameters = javaType.batchJobParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersBatchJobParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cloudwatchLogsParameters = javaType.cloudwatchLogsParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersCloudwatchLogsParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ecsTaskParameters = javaType.ecsTaskParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventbridgeEventBusParameters = javaType.eventbridgeEventBusParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEventbridgeEventBusParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpParameters = javaType.httpParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersHttpParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inputTemplate = javaType.inputTemplate().map({ args0 -> args0 }).orElse(null),
            kinesisStreamParameters = javaType.kinesisStreamParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersKinesisStreamParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lambdaFunctionParameters = javaType.lambdaFunctionParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersLambdaFunctionParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            redshiftDataParameters = javaType.redshiftDataParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersRedshiftDataParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sagemakerPipelineParameters = javaType.sagemakerPipelineParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersSagemakerPipelineParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqsQueueParameters = javaType.sqsQueueParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersSqsQueueParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            stepFunctionStateMachineParameters = javaType.stepFunctionStateMachineParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersStepFunctionStateMachineParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
