@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commands List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
 * @property environments The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
 * @property instanceType The instance type to use for a multi-node parallel job. This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
 * @property resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
 */
public data class PipeTargetParametersBatchJobParametersContainerOverrides(
    public val commands: List<String>? = null,
    public val environments: List<PipeTargetParametersBatchJobParametersContainerOverridesEnvironment>? = null,
    public val instanceType: String? = null,
    public val resourceRequirements: List<PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirement>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersBatchJobParametersContainerOverrides): PipeTargetParametersBatchJobParametersContainerOverrides =
            PipeTargetParametersBatchJobParametersContainerOverrides(
                commands = javaType.commands().map({ args0 -> args0 }),
                environments = javaType.environments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersBatchJobParametersContainerOverridesEnvironment.Companion.toKotlin(args0)
                    })
                }),
                instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
                resourceRequirements = javaType.resourceRequirements().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirement.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
