@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logStreamName The name of the log stream.
 * @property timestamp The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. This is the JSON path to the field in the event e.g. $.detail.timestamp
 */
public data class PipeTargetParametersCloudwatchLogsParameters(
    public val logStreamName: String? = null,
    public val timestamp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersCloudwatchLogsParameters): PipeTargetParametersCloudwatchLogsParameters = PipeTargetParametersCloudwatchLogsParameters(
            logStreamName = javaType.logStreamName().map({ args0 -> args0 }).orElse(null),
            timestamp = javaType.timestamp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
