@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property capacityProviderStrategies List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task. Valid values: true, false.
 * @property enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task. Valid values: true, false.
 * @property group Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
 * @property launchType Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The FARGATE value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. Valid Values: EC2, FARGATE, EXTERNAL
 * @property networkConfiguration Use this structure if the Amazon ECS task uses the awsvpc network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks. If you specify NetworkConfiguration when the target ECS task does not use the awsvpc network mode, the task fails. Detailed below.
 * @property overrides The overrides that are associated with a task. Detailed below.
 * @property placementConstraints An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
 * @property placementStrategies The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
 * @property platformVersion Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0. This structure is used only if LaunchType is FARGATE.
 * @property propagateTags Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action. Valid Values: TASK_DEFINITION
 * @property referenceId The reference ID to use for the task. Maximum length of 1,024.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taskCount The number of tasks to create based on TaskDefinition. The default is 1.
 * @property taskDefinitionArn The ARN of the task definition to use if the event target is an Amazon ECS task.
 */
public data class PipeTargetParametersEcsTaskParameters(
    public val capacityProviderStrategies: List<PipeTargetParametersEcsTaskParametersCapacityProviderStrategy>? = null,
    public val enableEcsManagedTags: Boolean? = null,
    public val enableExecuteCommand: Boolean? = null,
    public val group: String? = null,
    public val launchType: String? = null,
    public val networkConfiguration: PipeTargetParametersEcsTaskParametersNetworkConfiguration? =
        null,
    public val overrides: PipeTargetParametersEcsTaskParametersOverrides? = null,
    public val placementConstraints: List<PipeTargetParametersEcsTaskParametersPlacementConstraint>? =
        null,
    public val placementStrategies: List<PipeTargetParametersEcsTaskParametersPlacementStrategy>? =
        null,
    public val platformVersion: String? = null,
    public val propagateTags: String? = null,
    public val referenceId: String? = null,
    public val tags: Map<String, String>? = null,
    public val taskCount: Int? = null,
    public val taskDefinitionArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersEcsTaskParameters): PipeTargetParametersEcsTaskParameters = PipeTargetParametersEcsTaskParameters(
            capacityProviderStrategies = javaType.capacityProviderStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategy.Companion.toKotlin(args0)
                })
            }),
            enableEcsManagedTags = javaType.enableEcsManagedTags().map({ args0 -> args0 }).orElse(null),
            enableExecuteCommand = javaType.enableExecuteCommand().map({ args0 -> args0 }).orElse(null),
            group = javaType.group().map({ args0 -> args0 }).orElse(null),
            launchType = javaType.launchType().map({ args0 -> args0 }).orElse(null),
            networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersNetworkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersOverrides.Companion.toKotlin(args0)
                })
            }).orElse(null),
            placementConstraints = javaType.placementConstraints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersPlacementConstraint.Companion.toKotlin(args0)
                })
            }),
            placementStrategies = javaType.placementStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersPlacementStrategy.Companion.toKotlin(args0)
                })
            }),
            platformVersion = javaType.platformVersion().map({ args0 -> args0 }).orElse(null),
            propagateTags = javaType.propagateTags().map({ args0 -> args0 }).orElse(null),
            referenceId = javaType.referenceId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taskCount = javaType.taskCount().map({ args0 -> args0 }).orElse(null),
            taskDefinitionArn = javaType.taskDefinitionArn(),
        )
    }
}
