@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerOverrides One or more container overrides that are sent to a task. Detailed below.
 * @property cpu The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property ephemeralStorage The ephemeral storage setting override for the task.  Detailed below.
 * @property executionRoleArn The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
 * @property inferenceAcceleratorOverrides List of Elastic Inference accelerator overrides for the task. Detailed below.
 * @property memory The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
 * @property taskRoleArn The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role.
 */
public data class PipeTargetParametersEcsTaskParametersOverrides(
    public val containerOverrides: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverride>? = null,
    public val cpu: String? = null,
    public val ephemeralStorage: PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage? =
        null,
    public val executionRoleArn: String? = null,
    public val inferenceAcceleratorOverrides: List<PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride>? = null,
    public val memory: String? = null,
    public val taskRoleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersEcsTaskParametersOverrides): PipeTargetParametersEcsTaskParametersOverrides =
            PipeTargetParametersEcsTaskParametersOverrides(
                containerOverrides = javaType.containerOverrides().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverride.Companion.toKotlin(args0)
                    })
                }),
                cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
                ephemeralStorage = javaType.ephemeralStorage().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                executionRoleArn = javaType.executionRoleArn().map({ args0 -> args0 }).orElse(null),
                inferenceAcceleratorOverrides = javaType.inferenceAcceleratorOverrides().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride.Companion.toKotlin(args0)
                    })
                }),
                memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
                taskRoleArn = javaType.taskRoleArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
