@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
 * @property value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
 */
public data class
PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement(
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement): PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement =
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement(
                type = javaType.type(),
                `value` = javaType.`value`(),
            )
    }
}
