@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property database The name of the database. Required when authenticating using temporary credentials.
 * @property dbUser The database user name. Required when authenticating using temporary credentials.
 * @property secretManagerArn The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets Manager.
 * @property sqls List of SQL statements text to run, each of maximum length of 100,000.
 * @property statementName The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
 * @property withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
 */
public data class PipeTargetParametersRedshiftDataParameters(
    public val database: String,
    public val dbUser: String? = null,
    public val secretManagerArn: String? = null,
    public val sqls: List<String>,
    public val statementName: String? = null,
    public val withEvent: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersRedshiftDataParameters): PipeTargetParametersRedshiftDataParameters = PipeTargetParametersRedshiftDataParameters(
            database = javaType.database(),
            dbUser = javaType.dbUser().map({ args0 -> args0 }).orElse(null),
            secretManagerArn = javaType.secretManagerArn().map({ args0 -> args0 }).orElse(null),
            sqls = javaType.sqls().map({ args0 -> args0 }),
            statementName = javaType.statementName().map({ args0 -> args0 }).orElse(null),
            withEvent = javaType.withEvent().map({ args0 -> args0 }).orElse(null),
        )
    }
}
